(function() {
  var $, $$$, CompositeDisposable, KeybindingsPanel, TextEditorView, View, path, _, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  CompositeDisposable = require('atom').CompositeDisposable;

  _ref = require('atom-space-pen-views'), $ = _ref.$, $$$ = _ref.$$$, TextEditorView = _ref.TextEditorView, View = _ref.View;

  _ = require('underscore-plus');

  path = require('path');

  module.exports = KeybindingsPanel = (function(_super) {
    __extends(KeybindingsPanel, _super);

    function KeybindingsPanel() {
      return KeybindingsPanel.__super__.constructor.apply(this, arguments);
    }

    KeybindingsPanel.content = function() {
      return this.div((function(_this) {
        return function() {
          return _this.section({
            "class": 'keybinding-panel section'
          }, function() {
            _this.div({
              "class": 'section-heading icon icon-keyboard'
            }, 'Keybindings');
            _this.div({
              "class": 'text native-key-bindings',
              tabindex: -1
            }, function() {
              _this.span({
                "class": 'icon icon-question'
              });
              _this.span('You can override these keybindings by copying ');
              _this.span({
                "class": 'icon icon-clippy'
              });
              _this.span('and pasting them into ');
              return _this.a({
                "class": 'link',
                outlet: 'openUserKeymap'
              }, 'your keymap file');
            });
            _this.div({
              "class": 'editor-container'
            }, function() {
              return _this.subview('searchEditorView', new TextEditorView({
                mini: true
              }));
            });
            return _this.table({
              "class": 'native-key-bindings table text',
              tabindex: -1
            }, function() {
              _this.col({
                "class": 'keystroke'
              });
              _this.col({
                "class": 'command'
              });
              _this.col({
                "class": 'source'
              });
              _this.col({
                "class": 'selector'
              });
              _this.thead(function() {
                return _this.tr(function() {
                  _this.th({
                    "class": 'keystroke'
                  }, 'Keystroke');
                  _this.th({
                    "class": 'command'
                  }, 'Command');
                  _this.th({
                    "class": 'source'
                  }, 'Source');
                  return _this.th({
                    "class": 'selector'
                  }, 'Selector');
                });
              });
              return _this.tbody({
                outlet: 'keybindingRows'
              });
            });
          });
        };
      })(this));
    };

    KeybindingsPanel.prototype.initialize = function() {
      this.disposables = new CompositeDisposable();
      this.otherPlatformPattern = new RegExp("\\.platform-(?!" + (_.escapeRegExp(process.platform)) + "\\b)");
      this.platformPattern = new RegExp("\\.platform-" + (_.escapeRegExp(process.platform)) + "\\b");
      this.openUserKeymap.on('click', (function(_this) {
        return function() {
          atom.commands.dispatch(atom.views.getView(atom.workspace), 'application:open-your-keymap');
          return false;
        };
      })(this));
      this.searchEditorView.getModel().setPlaceholderText('Search keybindings');
      this.searchEditorView.getModel().onDidStopChanging((function(_this) {
        return function() {
          return _this.filterKeyBindings(_this.keyBindings, _this.searchEditorView.getText());
        };
      })(this));
      this.on('click', '.copy-icon', (function(_this) {
        return function(_arg) {
          var keyBinding, target;
          target = _arg.target;
          keyBinding = $(target).closest('tr').data('keyBinding');
          return _this.writeKeyBindingToClipboard(keyBinding);
        };
      })(this));
      this.disposables.add(atom.keymaps.onDidReloadKeymap((function(_this) {
        return function() {
          return _this.loadKeyBindings();
        };
      })(this)));
      this.disposables.add(atom.keymaps.onDidUnloadKeymap((function(_this) {
        return function() {
          return _this.loadKeyBindings();
        };
      })(this)));
      return this.loadKeyBindings();
    };

    KeybindingsPanel.prototype.detached = function() {
      return this.disposables.dispose();
    };

    KeybindingsPanel.prototype.loadKeyBindings = function() {
      this.keybindingRows.empty();
      this.keyBindings = _.sortBy(atom.keymaps.getKeyBindings(), 'keystrokes');
      this.appendKeyBindings(this.keyBindings);
      return this.filterKeyBindings(this.keyBindings, this.searchEditorView.getText());
    };

    KeybindingsPanel.prototype.focus = function() {
      return this.searchEditorView.focus();
    };

    KeybindingsPanel.prototype.filterKeyBindings = function(keyBindings, filterString) {
      var command, keyBinding, keystrokes, searchString, selector, source, _i, _len, _results;
      this.keybindingRows.empty();
      _results = [];
      for (_i = 0, _len = keyBindings.length; _i < _len; _i++) {
        keyBinding = keyBindings[_i];
        selector = keyBinding.selector, keystrokes = keyBinding.keystrokes, command = keyBinding.command, source = keyBinding.source;
        searchString = "" + selector + keystrokes + command + source;
        if (!searchString) {
          continue;
        }
        if (/^\s*$/.test(filterString) || searchString.indexOf(filterString) !== -1) {
          _results.push(this.appendKeyBinding(keyBinding));
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    KeybindingsPanel.prototype.appendKeyBindings = function(keyBindings) {
      var keyBinding, _i, _len, _results;
      _results = [];
      for (_i = 0, _len = keyBindings.length; _i < _len; _i++) {
        keyBinding = keyBindings[_i];
        _results.push(this.appendKeyBinding(keyBinding));
      }
      return _results;
    };

    KeybindingsPanel.prototype.appendKeyBinding = function(keyBinding) {
      var view;
      if (!this.showSelector(keyBinding.selector)) {
        return;
      }
      view = $(this.elementForKeyBinding(keyBinding));
      view.data('keyBinding', keyBinding);
      return this.keybindingRows.append(view);
    };

    KeybindingsPanel.prototype.showSelector = function(selector) {
      var segment, segments, _i, _len, _ref1;
      segments = (_ref1 = selector != null ? selector.split(',') : void 0) != null ? _ref1 : [];
      if (!segments) {
        return true;
      }
      for (_i = 0, _len = segments.length; _i < _len; _i++) {
        segment = segments[_i];
        if (this.platformPattern.test(segment)) {
          return true;
        }
        if (!this.otherPlatformPattern.test(segment)) {
          return true;
        }
      }
      return false;
    };

    KeybindingsPanel.prototype.elementForKeyBinding = function(keyBinding) {
      var command, keystrokes, selector, source;
      selector = keyBinding.selector, keystrokes = keyBinding.keystrokes, command = keyBinding.command, source = keyBinding.source;
      source = this.determineSource(source);
      return $$$(function() {
        var rowClasses;
        rowClasses = source === 'User' ? 'is-user' : '';
        return this.tr({
          "class": rowClasses
        }, (function(_this) {
          return function() {
            _this.td({
              "class": 'keystroke'
            }, function() {
              _this.span({
                "class": 'icon icon-clippy copy-icon'
              });
              return _this.span(keystrokes);
            });
            _this.td({
              "class": 'command'
            }, command);
            _this.td({
              "class": 'source'
            }, source);
            return _this.td({
              "class": 'selector'
            }, selector);
          };
        })(this));
      });
    };

    KeybindingsPanel.prototype.writeKeyBindingToClipboard = function(_arg) {
      var command, content, keymapExtension, keystrokes, selector;
      selector = _arg.selector, keystrokes = _arg.keystrokes, command = _arg.command;
      keymapExtension = path.extname(atom.keymaps.getUserKeymapPath());
      if (keymapExtension === '.cson') {
        content = "'" + selector + "':\n  '" + keystrokes + "': '" + command + "'";
      } else {
        content = "\"" + selector + "\": {\n  \"" + keystrokes + "\": \"" + command + "\"\n}";
      }
      return atom.clipboard.write(content);
    };

    KeybindingsPanel.prototype.determineSource = function(filePath) {
      var packageName, packageNameIndex, pathParts, _ref1;
      if (!filePath) {
        return 'Unknown';
      }
      if (filePath.indexOf(path.join(atom.getLoadSettings().resourcePath, 'keymaps')) === 0) {
        return 'Core';
      } else if (filePath === atom.keymaps.getUserKeymapPath()) {
        return 'User';
      } else {
        pathParts = filePath.split(path.sep);
        packageNameIndex = pathParts.length - 3;
        packageName = (_ref1 = pathParts[packageNameIndex]) != null ? _ref1 : '';
        return _.undasherize(_.uncamelcase(packageName));
      }
    };

    return KeybindingsPanel;

  })(View);

}).call(this);
