(function() {
  var SettingsView, configUri, createSettingsView, deserializer, openPanel, settingsView;

  SettingsView = null;

  settingsView = null;

  configUri = 'atom://config';

  createSettingsView = function(params) {
    if (SettingsView == null) {
      SettingsView = require('./settings-view');
    }
    return settingsView = new SettingsView(params);
  };

  openPanel = function(panelName) {
    if (settingsView == null) {
      settingsView = createSettingsView({
        uri: configUri
      });
    }
    return settingsView.showPanel(panelName);
  };

  deserializer = {
    name: 'SettingsView',
    version: 2,
    deserialize: function(state) {
      if (state.constructor === Object) {
        return createSettingsView(state);
      }
    }
  };

  atom.deserializers.add(deserializer);

  module.exports = {
    activate: function() {
      atom.workspace.addOpener(function(uri) {
        var match, panelName;
        if (uri.startsWith(configUri)) {
          settingsView = createSettingsView({
            uri: uri
          });
          if (match = /config\/([a-z]+)/gi.exec(uri)) {
            panelName = match[1];
            panelName = panelName[0].toUpperCase() + panelName.slice(1);
            openPanel(panelName);
          }
          return settingsView;
        }
      });
      return atom.commands.add('atom-workspace', {
        'settings-view:open': function() {
          return atom.workspace.open(configUri);
        },
        'settings-view:show-keybindings': function() {
          return atom.workspace.open("" + configUri + "/keybindings");
        },
        'settings-view:change-themes': function() {
          return atom.workspace.open("" + configUri + "/themes");
        },
        'settings-view:install-packages-and-themes': function() {
          return atom.workspace.open("" + configUri + "/install");
        },
        'settings-view:uninstall-themes': function() {
          return atom.workspace.open("" + configUri + "/themes");
        },
        'settings-view:uninstall-packages': function() {
          return atom.workspace.open("" + configUri + "/packages");
        },
        'settings-view:check-for-package-updates': function() {
          return atom.workspace.open("" + configUri + "/updates");
        }
      });
    },
    consumeStatusBar: function(statusBar) {
      var PackageManager, packageManager;
      PackageManager = require('./package-manager');
      packageManager = new PackageManager();
      return packageManager.getOutdated().then(function(packages) {
        var PackageUpdatesStatusView, packageUpdatesStatusView;
        if (packages.length > 0) {
          PackageUpdatesStatusView = require('./package-updates-status-view');
          return packageUpdatesStatusView = new PackageUpdatesStatusView(statusBar, packages);
        }
      });
    }
  };

}).call(this);
