(function() {
  var PackageCard, Subscriber, View, shell, _,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ = require('underscore-plus');

  View = require('atom-space-pen-views').View;

  Subscriber = require('emissary').Subscriber;

  shell = require('shell');

  module.exports = PackageCard = (function(_super) {
    __extends(PackageCard, _super);

    function PackageCard() {
      return PackageCard.__super__.constructor.apply(this, arguments);
    }

    Subscriber.includeInto(PackageCard);

    PackageCard.content = function(_arg) {
      var description, name, owner, repository, version;
      name = _arg.name, description = _arg.description, version = _arg.version, repository = _arg.repository;
      owner = PackageCard.prototype.ownerFromRepository(repository);
      if (description == null) {
        description = '';
      }
      return this.div({
        "class": 'package-card col-lg-8'
      }, (function(_this) {
        return function() {
          _this.div({
            "class": 'stats pull-right'
          }, function() {
            _this.span({
              "class": "stats-item"
            }, function() {
              _this.span({
                "class": 'icon icon-versions'
              });
              return _this.span({
                "class": 'value'
              }, version);
            });
            return _this.span({
              "class": 'stats-item'
            }, function() {
              _this.span({
                "class": 'icon icon-cloud-download'
              });
              return _this.span({
                outlet: 'downloadCount',
                "class": 'value'
              });
            });
          });
          _this.div({
            "class": 'body'
          }, function() {
            _this.h4({
              "class": 'card-name'
            }, function() {
              return _this.a({
                outlet: 'packageName'
              }, name);
            });
            return _this.span({
              outlet: 'packageDescription',
              "class": 'package-description'
            }, description);
          });
          return _this.div({
            "class": 'meta'
          }, function() {
            _this.div({
              "class": 'meta-user'
            }, function() {
              _this.a({
                outlet: 'avatarLink',
                href: "https://atom.io/users/" + owner
              }, function() {
                return _this.img({
                  outlet: 'avatar',
                  "class": 'avatar',
                  src: 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7'
                });
              });
              return _this.a({
                outlet: 'loginLink',
                "class": 'author',
                href: "https://atom.io/users/" + owner
              }, owner);
            });
            return _this.div({
              "class": 'meta-controls'
            }, function() {
              _this.div({
                "class": 'btn-group'
              }, function() {
                return _this.button({
                  type: 'button',
                  "class": 'btn btn-info icon icon-cloud-download install-button',
                  outlet: 'installButton'
                }, 'Install');
              });
              return _this.div({
                outlet: 'buttons',
                "class": 'btn-group'
              }, function() {
                _this.button({
                  type: 'button',
                  "class": 'btn icon icon-gear settings',
                  outlet: 'settingsButton'
                }, 'Settings');
                _this.button({
                  type: 'button',
                  "class": 'btn icon icon-trashcan uninstall',
                  outlet: 'uninstallButton'
                }, 'Uninstall');
                _this.button({
                  type: 'button',
                  "class": 'btn icon icon-playback-pause enablement',
                  outlet: 'enablementButton'
                }, function() {
                  return _this.span({
                    "class": 'disable-text'
                  }, 'Disable');
                });
                return _this.button({
                  type: 'button',
                  "class": 'btn status-indicator',
                  tabindex: -1,
                  outlet: 'statusIndicator'
                });
              });
            });
          });
        };
      })(this));
    };

    PackageCard.prototype.initialize = function(pack, packageManager, opts) {
      var owner;
      this.pack = pack;
      this.packageManager = packageManager;
      this.client = this.packageManager.getClient();
      this.type = this.pack.theme ? 'theme' : 'package';
      owner = this.ownerFromRepository(this.pack.repository);
      this.filterText = "" + this.pack.name + " " + owner;
      this.name = this.pack.name;
      this.handlePackageEvents();
      this.updateEnablement();
      this.loadCachedMetadata();
      if (atom.packages.isBundledPackage(this.pack.name)) {
        this.installButton.remove();
        this.uninstallButton.remove();
      }
      if (this.type === 'theme') {
        this.statusIndicator.remove();
        this.enablementButton.remove();
      }
      if (!this.hasSettings(this.pack)) {
        this.settingsButton.remove();
      }
      if (opts != null ? opts.onSettingsView : void 0) {
        this.settingsButton.remove();
      } else {
        this.on('click', (function(_this) {
          return function() {
            var _ref;
            return (_ref = _this.parents('.settings-view').view()) != null ? _ref.showPanel(_this.pack.name, {
              back: opts != null ? opts.back : void 0,
              pack: _this.pack
            }) : void 0;
          };
        })(this));
        this.settingsButton.on('click', (function(_this) {
          return function() {
            var _ref;
            event.stopPropagation();
            return (_ref = _this.parents('.settings-view').view()) != null ? _ref.showPanel(_this.pack.name, {
              back: opts != null ? opts.back : void 0,
              pack: _this.pack
            }) : void 0;
          };
        })(this));
      }
      this.installButton.on('click', (function(_this) {
        return function(event) {
          event.stopPropagation();
          return _this.install();
        };
      })(this));
      this.uninstallButton.on('click', (function(_this) {
        return function(event) {
          event.stopPropagation();
          return _this.uninstall();
        };
      })(this));
      this.packageName.on('click', (function(_this) {
        return function(event) {
          var packageType;
          event.stopPropagation();
          packageType = _this.pack.theme ? 'themes' : 'packages';
          return shell.openExternal("https://atom.io/" + packageType + "/" + _this.pack.name);
        };
      })(this));
      return this.enablementButton.on('click', (function(_this) {
        return function() {
          if (_this.isDisabled()) {
            atom.packages.enablePackage(_this.pack.name);
          } else {
            atom.packages.disablePackage(_this.pack.name);
          }
          return false;
        };
      })(this));
    };

    PackageCard.prototype.detached = function() {
      return this.unsubscribe();
    };

    PackageCard.prototype.ownerFromRepository = function(repository) {
      var loginRegex, repo, _ref, _ref1;
      if (!repository) {
        return '';
      }
      loginRegex = /github\.com\/([\w-]+)\/.+/;
      if (typeof repository === "string") {
        repo = repository;
      } else {
        repo = repository.url;
      }
      return (_ref = (_ref1 = repo.match(loginRegex)) != null ? _ref1[1] : void 0) != null ? _ref : '';
    };

    PackageCard.prototype.loadCachedMetadata = function() {
      this.client.avatar(this.ownerFromRepository(this.pack.repository), (function(_this) {
        return function(err, avatarPath) {
          if (avatarPath) {
            return _this.avatar.attr('src', "file://" + avatarPath);
          }
        };
      })(this));
      return this.client["package"](this.pack.name, (function(_this) {
        return function(err, data) {
          var _ref;
          if (data == null) {
            data = {};
          }
          _this.packageData = data;
          return _this.downloadCount.text((_ref = data.downloads) != null ? _ref.toLocaleString() : void 0);
        };
      })(this));
    };

    PackageCard.prototype.updateEnablement = function() {
      if (this.type === 'theme') {
        return this.enablementButton.hide();
      }
      if (atom.packages.isPackageDisabled(this.pack.name)) {
        this.addClass('disabled');
        this.enablementButton.find('.disable-text').text('Enable');
        this.enablementButton.addClass('icon-playback-play').removeClass('icon-playback-pause');
        return this.statusIndicator.addClass('is-disabled');
      } else {
        this.removeClass('disabled');
        this.enablementButton.find('.disable-text').text('Disable');
        this.enablementButton.addClass('icon-playback-pause').removeClass('icon-playback-play');
        return this.statusIndicator.removeClass('is-disabled');
      }
    };

    PackageCard.prototype.handlePackageEvents = function() {
      atom.packages.onDidDeactivatePackage((function(_this) {
        return function(pack) {
          if (pack.name === _this.pack.name) {
            return _this.updateEnablement();
          }
        };
      })(this));
      atom.packages.onDidActivatePackage((function(_this) {
        return function(pack) {
          if (pack.name === _this.pack.name) {
            return _this.updateEnablement();
          }
        };
      })(this));
      atom.config.onDidChange('core.disabledPackages', (function(_this) {
        return function() {
          return _this.updateEnablement();
        };
      })(this));
      this.subscribeToPackageEvent('package-installed package-install-failed theme-installed theme-install-failed', (function(_this) {
        return function(pack, error) {
          _this.installButton.prop('disabled', false);
          if (error == null) {
            _this.updateEnablement();
            _this.installButton.hide();
            _this.uninstallButton.show();
            _this.settingsButton.show();
            _this.enablementButton.show();
            return _this.statusIndicator.show();
          }
        };
      })(this));
      this.subscribeToPackageEvent('package-installing', (function(_this) {
        return function(pack) {
          _this.installButton.prop('disabled', true);
          _this.installButton.show();
          return _this.uninstallButton.hide();
        };
      })(this));
      this.subscribeToPackageEvent('package-uninstalling', (function(_this) {
        return function(pack) {
          return _this.installButton.prop('disabled', true);
        };
      })(this));
      this.subscribeToPackageEvent('package-uninstalled package-uninstall-failed theme-uninstalled theme-uninstall-failed', (function(_this) {
        return function(pack, error) {
          _this.installButton.prop('disabled', false);
          if (error == null) {
            _this.installButton.show();
            _this.uninstallButton.hide();
            _this.settingsButton.hide();
            _this.enablementButton.hide();
            return _this.statusIndicator.hide();
          }
        };
      })(this));
      if (this.isInstalled() || this.isDisabled()) {
        this.installButton.hide();
        return this.uninstallButton.show();
      } else {
        this.settingsButton.hide();
        this.uninstallButton.hide();
        this.enablementButton.hide();
        return this.statusIndicator.hide();
      }
    };

    PackageCard.prototype.isInstalled = function() {
      return atom.packages.isPackageLoaded(this.pack.name) && !atom.packages.isPackageDisabled(this.pack.name);
    };

    PackageCard.prototype.isDisabled = function() {
      return atom.packages.isPackageDisabled(this.pack.name);
    };

    PackageCard.prototype.hasSettings = function(pack) {
      return atom.config.get(pack.name) != null;
    };

    PackageCard.prototype.subscribeToPackageEvent = function(event, callback) {
      return this.subscribe(this.packageManager, event, (function(_this) {
        return function(pack, error) {
          if (pack.name === _this.pack.name) {
            return callback(pack, error);
          }
        };
      })(this));
    };

    PackageCard.prototype.install = function() {
      this.installButton.addClass('is-installing');
      this.packageManager.emit('package-installing', this.pack);
      return this.packageManager.install(this.pack, (function(_this) {
        return function(error) {
          var _ref;
          _this.installButton.removeClass('is-installing');
          if (error != null) {
            return console.error("Installing " + _this.type + " " + _this.pack.name + " failed", (_ref = error.stack) != null ? _ref : error, error.stderr);
          } else {
            if (_this.isDisabled()) {
              return atom.packages.enablePackage(_this.pack.name);
            }
          }
        };
      })(this));
    };

    PackageCard.prototype.uninstall = function() {
      this.packageManager.emit('package-uninstalling', this.pack);
      return this.packageManager.uninstall(this.pack, (function(_this) {
        return function(error) {
          var _ref;
          if (error != null) {
            return console.error("Uninstalling " + _this.type + " " + _this.pack.name + " failed", (_ref = error.stack) != null ? _ref : error, error.stderr);
          }
        };
      })(this));
    };

    return PackageCard;

  })(View);

}).call(this);
