(function() {
  var ErrorView, PackageCard, PackageDetailView, PackageGrammarsView, PackageKeymapView, PackageReadmeView, PackageSnippetsView, SettingsPanel, Subscriber, View, fs, path, shell, url, _,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  path = require('path');

  url = require('url');

  _ = require('underscore-plus');

  fs = require('fs-plus');

  shell = require('shell');

  View = require('atom-space-pen-views').View;

  Subscriber = require('emissary').Subscriber;

  ErrorView = require('./error-view');

  PackageCard = require('./package-card');

  PackageGrammarsView = require('./package-grammars-view');

  PackageKeymapView = require('./package-keymap-view');

  PackageReadmeView = require('./package-readme-view');

  PackageSnippetsView = require('./package-snippets-view');

  SettingsPanel = require('./settings-panel');

  module.exports = PackageDetailView = (function(_super) {
    __extends(PackageDetailView, _super);

    function PackageDetailView() {
      return PackageDetailView.__super__.constructor.apply(this, arguments);
    }

    Subscriber.includeInto(PackageDetailView);

    PackageDetailView.content = function(pack, packageManager) {
      return this.div({
        "class": 'package-detail'
      }, (function(_this) {
        return function() {
          _this.ol({
            outlet: 'breadcrumbContainer',
            "class": 'native-key-bindings breadcrumb',
            tabindex: -1
          }, function() {
            _this.li(function() {
              return _this.a({
                outlet: 'breadcrumb'
              });
            });
            return _this.li({
              "class": 'active'
            }, function() {
              return _this.a({
                outlet: 'title'
              });
            });
          });
          _this.section({
            "class": 'section'
          }, function() {
            return _this.form({
              "class": 'section-container package-detail-view'
            }, function() {
              _this.div({
                outlet: 'updateArea',
                "class": 'alert alert-success package-update'
              }, function() {
                _this.span({
                  outlet: 'updateLabel',
                  "class": 'icon icon-squirrel update-message'
                });
                return _this.span({
                  outlet: 'updateLink',
                  "class": 'alert-link update-link icon icon-cloud-download'
                }, 'Install');
              });
              _this.div({
                "class": 'container package-container'
              }, function() {
                return _this.div({
                  "class": 'row'
                }, function() {
                  return _this.subview('packageCard', new PackageCard(pack.metadata, packageManager, {
                    onSettingsView: true
                  }));
                });
              });
              _this.p({
                outlet: 'packageRepo',
                "class": 'link icon icon-repo repo-link'
              });
              _this.p({
                outlet: 'startupTime',
                "class": 'text icon icon-dashboard native-key-bindings',
                tabindex: -1
              });
              _this.div({
                outlet: 'buttons',
                "class": 'btn-wrap-group'
              }, function() {
                _this.button({
                  outlet: 'learnMoreButton',
                  "class": 'btn btn-default icon icon-link'
                }, 'View on Atom.io');
                _this.button({
                  outlet: 'issueButton',
                  "class": 'btn btn-default icon icon-bug'
                }, 'Report Issue');
                _this.button({
                  outlet: 'changelogButton',
                  "class": 'btn btn-default icon icon-squirrel'
                }, 'CHANGELOG');
                _this.button({
                  outlet: 'licenseButton',
                  "class": 'btn btn-default icon icon-law'
                }, 'LICENSE');
                return _this.button({
                  outlet: 'openButton',
                  "class": 'btn btn-default icon icon-link-external'
                }, 'View Code');
              });
              return _this.div({
                outlet: 'errors'
              });
            });
          });
          return _this.div({
            outlet: 'sections'
          });
        };
      })(this));
    };

    PackageDetailView.prototype.initialize = function(pack, packageManager) {
      this.pack = pack;
      this.packageManager = packageManager;
      this.activate();
      this.populate();
      this.handleButtonEvents();
      this.updateFileButtons();
      this.checkForUpdate();
      return this.subscribeToPackageManager();
    };

    PackageDetailView.prototype.activate = function() {
      if (atom.packages.isPackageLoaded(this.pack.name) && !atom.packages.isPackageActive(this.pack.name)) {
        return this.pack.activateConfig();
      }
    };

    PackageDetailView.prototype.detached = function() {
      return this.unsubscribe();
    };

    PackageDetailView.prototype.beforeShow = function(opts) {
      if (opts != null ? opts.back : void 0) {
        return this.breadcrumb.text(opts.back).on('click', (function(_this) {
          return function() {
            var _ref;
            return (_ref = _this.parents('.settings-view').view()) != null ? _ref.showPanel(opts.back) : void 0;
          };
        })(this));
      } else {
        return this.breadcrumbContainer.hide();
      }
    };

    PackageDetailView.prototype.populate = function() {
      var repoName, repoUrl;
      this.title.text("" + (_.undasherize(_.uncamelcase(this.pack.name))));
      this.type = this.pack.metadata.theme ? 'theme' : 'package';
      if (repoUrl = this.packageManager.getRepositoryUrl(this.pack)) {
        repoName = url.parse(repoUrl).pathname;
        this.packageRepo.text(repoName.substring(1)).show();
      } else {
        this.packageRepo.hide();
      }
      return this.updateInstalledState();
    };

    PackageDetailView.prototype.updateInstalledState = function() {
      var readme;
      this.sections.empty();
      this.updateFileButtons();
      this.activate();
      if (this.isInstalled()) {
        this.sections.append(new SettingsPanel(this.pack.name, {
          includeTitle: false
        }));
        this.sections.append(new PackageKeymapView(this.pack.name));
        this.sections.append(new PackageGrammarsView(this.pack.path));
        this.sections.append(new PackageSnippetsView(this.pack.path));
        this.startupTime.html("This " + this.type + " added <span class='highlight'>" + (this.getStartupTime()) + "ms</span> to startup time.");
      } else {
        this.startupTime.hide();
        this.openButton.hide();
      }
      readme = this.pack.metadata.readme ? this.pack.metadata.readme : null;
      if (this.readmePath && !readme) {
        readme = fs.readFileSync(this.readmePath, {
          encoding: 'utf8'
        });
      }
      return this.sections.append(new PackageReadmeView(readme));
    };

    PackageDetailView.prototype.subscribeToPackageManager = function() {
      this.subscribe(this.packageManager, 'theme-installed package-installed', (function(_this) {
        return function(pack) {
          _this.pack = atom.packages.getLoadedPackage(pack.name);
          return _this.updateInstalledState();
        };
      })(this));
      this.subscribe(this.packageManager, 'theme-uninstalled package-uninstalled', (function(_this) {
        return function(pack) {
          return _this.updateInstalledState();
        };
      })(this));
      return this.subscribe(this.packageManager, 'theme-updated package-updated', (function(_this) {
        return function(pack, newVersion) {
          var updatedPackage;
          if (_this.pack.name !== pack.name) {
            return;
          }
          _this.updateFileButtons();
          _this.updateArea.hide();
          if (updatedPackage = atom.packages.getLoadedPackage(_this.pack.name)) {
            _this.pack = updatedPackage;
            return _this.populate();
          }
        };
      })(this));
    };

    PackageDetailView.prototype.handleButtonEvents = function() {
      this.packageRepo.on('click', (function(_this) {
        return function() {
          var repoUrl;
          if (repoUrl = _this.packageManager.getRepositoryUrl(_this.pack)) {
            shell.openExternal(repoUrl);
          }
          return false;
        };
      })(this));
      this.issueButton.on('click', (function(_this) {
        return function() {
          var repoUrl;
          if (repoUrl = _this.packageManager.getRepositoryUrl(_this.pack)) {
            shell.openExternal("" + repoUrl + "/issues/new");
          }
          return false;
        };
      })(this));
      this.changelogButton.on('click', (function(_this) {
        return function() {
          if (_this.changelogPath) {
            _this.openMarkdownFile(_this.changelogPath);
          }
          return false;
        };
      })(this));
      this.licenseButton.on('click', (function(_this) {
        return function() {
          if (_this.licensePath) {
            _this.openMarkdownFile(_this.licensePath);
          }
          return false;
        };
      })(this));
      this.openButton.on('click', (function(_this) {
        return function() {
          if (fs.existsSync(_this.pack.path)) {
            atom.open({
              pathsToOpen: [_this.pack.path]
            });
          }
          return false;
        };
      })(this));
      return this.learnMoreButton.on('click', (function(_this) {
        return function() {
          shell.openExternal("https://atom.io/packages/" + _this.pack.name);
          return false;
        };
      })(this));
    };

    PackageDetailView.prototype.openMarkdownFile = function(path) {
      if (atom.packages.isPackageActive('markdown-preview')) {
        return atom.workspace.open("" + (encodeURI("markdown-preview://" + path)));
      } else {
        return atom.workspace.open(path);
      }
    };

    PackageDetailView.prototype.updateFileButtons = function() {
      var child, _i, _len, _ref;
      this.changelogPath = null;
      this.licensePath = null;
      this.readmePath = null;
      _ref = fs.listSync(this.pack.path);
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        child = _ref[_i];
        switch (path.basename(child, path.extname(child)).toLowerCase()) {
          case 'changelog':
          case 'history':
            this.changelogPath = child;
            break;
          case 'license':
          case 'licence':
            this.licensePath = child;
            break;
          case 'readme':
            this.readmePath = child;
        }
        if (this.readmePath && this.changelogPath && this.licensePath) {
          break;
        }
      }
      if (this.changelogPath) {
        this.changelogButton.show();
      } else {
        this.changelogButton.hide();
      }
      if (this.licensePath) {
        return this.licenseButton.show();
      } else {
        return this.licenseButton.hide();
      }
    };

    PackageDetailView.prototype.getStartupTime = function() {
      var activateTime, loadTime, _ref, _ref1;
      loadTime = (_ref = this.pack.loadTime) != null ? _ref : 0;
      activateTime = (_ref1 = this.pack.activateTime) != null ? _ref1 : 0;
      return loadTime + activateTime;
    };

    PackageDetailView.prototype.installUpdate = function() {
      if (this.updateLink.prop('disabled')) {
        return;
      }
      if (!this.availableVersion) {
        return;
      }
      this.updateLink.prop('disabled', true);
      this.updateLink.text('Installing\u2026');
      return this.packageManager.update(this.pack, this.availableVersion, (function(_this) {
        return function(error) {
          if (error != null) {
            _this.updateLink.prop('disabled', false);
            _this.updateLink.text('Install');
            return _this.errors.append(new ErrorView(_this.packageManager, error));
          }
        };
      })(this));
    };

    PackageDetailView.prototype.checkForUpdate = function() {
      this.updateArea.hide();
      if (atom.packages.isBundledPackage(this.pack.name)) {
        return;
      }
      this.updateLink.on('click', (function(_this) {
        return function() {
          return _this.installUpdate();
        };
      })(this));
      return this.packageManager.getOutdated().then((function(_this) {
        return function(packages) {
          var pack, _i, _len, _results;
          _results = [];
          for (_i = 0, _len = packages.length; _i < _len; _i++) {
            pack = packages[_i];
            if (pack.name === _this.pack.name) {
              if (_this.packageManager.canUpgrade(_this.pack, pack.latestVersion)) {
                _this.availableVersion = pack.latestVersion;
                _this.updateLabel.text("Version " + _this.availableVersion + " is now available!");
                _results.push(_this.updateArea.show());
              } else {
                _results.push(void 0);
              }
            }
          }
          return _results;
        };
      })(this));
    };

    PackageDetailView.prototype.isInstalled = function() {
      return atom.packages.isPackageLoaded(this.pack.name) && !atom.packages.isPackageDisabled(this.pack.name);
    };

    return PackageDetailView;

  })(View);

}).call(this);
