(function() {
  var $$$, CompositeDisposable, PackageGrammarsView, SettingsPanel, View, path, _, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  path = require('path');

  _ = require('underscore-plus');

  CompositeDisposable = require('atom').CompositeDisposable;

  _ref = require('atom-space-pen-views'), $$$ = _ref.$$$, View = _ref.View;

  SettingsPanel = require('./settings-panel');

  module.exports = PackageGrammarsView = (function(_super) {
    __extends(PackageGrammarsView, _super);

    function PackageGrammarsView() {
      return PackageGrammarsView.__super__.constructor.apply(this, arguments);
    }

    PackageGrammarsView.content = function() {
      return this.section({
        "class": 'package-grammars'
      }, (function(_this) {
        return function() {
          return _this.div({
            outlet: 'grammarSettings'
          });
        };
      })(this));
    };

    PackageGrammarsView.prototype.initialize = function(packagePath) {
      this.disposables = new CompositeDisposable();
      this.packagePath = path.join(packagePath, path.sep);
      this.addGrammars();
      this.disposables.add(atom.grammars.onDidAddGrammar((function(_this) {
        return function() {
          return _this.addGrammars();
        };
      })(this)));
      return this.disposables.add(atom.grammars.onDidUpdateGrammar((function(_this) {
        return function() {
          return _this.addGrammars();
        };
      })(this)));
    };

    PackageGrammarsView.prototype.detached = function() {
      return this.disposables.dispose();
    };

    PackageGrammarsView.prototype.getPackageGrammars = function() {
      var grammar, grammars, packageGrammars, _i, _len, _ref1;
      packageGrammars = [];
      grammars = (_ref1 = atom.grammars.grammars) != null ? _ref1 : [];
      for (_i = 0, _len = grammars.length; _i < _len; _i++) {
        grammar = grammars[_i];
        if (grammar.path) {
          if (grammar.path.indexOf(this.packagePath) === 0) {
            packageGrammars.push(grammar);
          }
        }
      }
      return packageGrammars.sort(function(grammar1, grammar2) {
        var name1, name2, _ref2, _ref3, _ref4, _ref5;
        name1 = (_ref2 = (_ref3 = grammar1.name) != null ? _ref3 : grammar1.scopeName) != null ? _ref2 : '';
        name2 = (_ref4 = (_ref5 = grammar2.name) != null ? _ref5 : grammar2.scopeName) != null ? _ref4 : '';
        return name1.localeCompare(name2);
      });
    };

    PackageGrammarsView.prototype.addGrammarHeading = function(grammar, panel) {
      return panel.find('.section-body').prepend($$$(function() {
        return this.div({
          "class": 'native-key-bindings text',
          tabindex: -1
        }, (function(_this) {
          return function() {
            _this.div({
              "class": 'grammar-scope'
            }, function() {
              var _ref1;
              _this.strong('Scope: ');
              return _this.span((_ref1 = grammar.scopeName) != null ? _ref1 : '');
            });
            return _this.div({
              "class": 'grammar-filetypes'
            }, function() {
              var _ref1, _ref2;
              _this.strong('File Types: ');
              return _this.span((_ref1 = (_ref2 = grammar.fileTypes) != null ? _ref2.join(', ') : void 0) != null ? _ref1 : '');
            });
          };
        })(this));
      }));
    };

    PackageGrammarsView.prototype.addGrammars = function() {
      var grammar, panel, scopeName, title, _i, _len, _ref1, _results;
      this.grammarSettings.empty();
      _ref1 = this.getPackageGrammars();
      _results = [];
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        grammar = _ref1[_i];
        scopeName = grammar.scopeName;
        if (!scopeName) {
          continue;
        }
        if (!scopeName.startsWith('.')) {
          scopeName = "." + scopeName;
        }
        title = "" + grammar.name + " Grammar";
        panel = new SettingsPanel(null, {
          title: title,
          scopeName: scopeName,
          icon: 'puzzle'
        });
        this.addGrammarHeading(grammar, panel);
        _results.push(this.grammarSettings.append(panel));
      }
      return _results;
    };

    return PackageGrammarsView;

  })(View);

}).call(this);
