(function() {
  var $, $$$, PackageKeymapView, View, path, _, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  path = require('path');

  _ = require('underscore-plus');

  _ref = require('atom-space-pen-views'), $ = _ref.$, $$$ = _ref.$$$, View = _ref.View;

  module.exports = PackageKeymapView = (function(_super) {
    __extends(PackageKeymapView, _super);

    function PackageKeymapView() {
      return PackageKeymapView.__super__.constructor.apply(this, arguments);
    }

    PackageKeymapView.content = function() {
      return this.section({
        "class": 'section'
      }, (function(_this) {
        return function() {
          _this.div({
            "class": 'section-heading icon icon-keyboard'
          }, 'Keybindings');
          return _this.table({
            "class": 'package-keymap-table table native-key-bindings text',
            tabindex: -1
          }, function() {
            _this.thead(function() {
              return _this.tr(function() {
                _this.th('Keystroke');
                _this.th('Command');
                return _this.th('Selector');
              });
            });
            return _this.tbody({
              outlet: 'keybindingItems'
            });
          });
        };
      })(this));
    };

    PackageKeymapView.prototype.initialize = function(namespace) {
      var command, keyBinding, keyBindingView, keystrokes, otherPlatformPattern, selector, _i, _len, _ref1;
      otherPlatformPattern = new RegExp("\\.platform-(?!" + (_.escapeRegExp(process.platform)) + "\\b)");
      _ref1 = atom.keymaps.getKeyBindings();
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        keyBinding = _ref1[_i];
        command = keyBinding.command, keystrokes = keyBinding.keystrokes, selector = keyBinding.selector;
        if ((command != null ? typeof command.indexOf === "function" ? command.indexOf("" + namespace + ":") : void 0 : void 0) !== 0) {
          continue;
        }
        if (otherPlatformPattern.test(selector)) {
          continue;
        }
        keyBindingView = $$$(function() {
          return this.tr((function(_this) {
            return function() {
              _this.td(function() {
                _this.span({
                  "class": 'icon icon-clippy copy-icon'
                });
                return _this.span(keystrokes);
              });
              _this.td(command);
              return _this.td(selector);
            };
          })(this));
        });
        keyBindingView = $(keyBindingView);
        keyBindingView.data('keyBinding', keyBinding);
        this.keybindingItems.append(keyBindingView);
      }
      if (!(this.keybindingItems.children().length > 0)) {
        this.hide();
      }
      return this.on('click', '.copy-icon', (function(_this) {
        return function(_arg) {
          var target;
          target = _arg.target;
          keyBinding = $(target).closest('tr').data('keyBinding');
          return _this.writeKeyBindingToClipboard(keyBinding);
        };
      })(this));
    };

    PackageKeymapView.prototype.writeKeyBindingToClipboard = function(_arg) {
      var command, content, keymapExtension, keystrokes, selector;
      selector = _arg.selector, keystrokes = _arg.keystrokes, command = _arg.command;
      keymapExtension = path.extname(atom.keymaps.getUserKeymapPath());
      if (keymapExtension === '.cson') {
        content = "'" + selector + "':\n  '" + keystrokes + "': '" + command + "'";
      } else {
        content = "\"" + selector + "\": {\n  \"" + keystrokes + "\": \"" + command + "\"\n}";
      }
      return atom.clipboard.write(content);
    };

    return PackageKeymapView;

  })(View);

}).call(this);
