(function() {
  var $, $$$, PackageReadmeView, View, cheerio, fs, roaster, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ref = require('atom-space-pen-views'), $ = _ref.$, $$$ = _ref.$$$, View = _ref.View;

  roaster = require('roaster');

  fs = require('fs');

  cheerio = require('cheerio');

  module.exports = PackageReadmeView = (function(_super) {
    var sanitize;

    __extends(PackageReadmeView, _super);

    function PackageReadmeView() {
      return PackageReadmeView.__super__.constructor.apply(this, arguments);
    }

    PackageReadmeView.content = function() {
      return this.section({
        "class": 'section'
      }, (function(_this) {
        return function() {
          return _this.div({
            "class": 'section-container'
          }, function() {
            _this.div({
              "class": 'section-heading icon icon-book'
            }, 'README');
            return _this.div({
              "class": 'package-readme',
              outlet: 'packageReadme'
            });
          });
        };
      })(this));
    };

    PackageReadmeView.prototype.initialize = function(readme) {
      readme = readme || "### No README.";
      return roaster(readme, (function(_this) {
        return function(err, content) {
          if (err) {
            _this.packageReadme.append("<h3>Error parsing README</h3>");
          }
          return _this.packageReadme.append(sanitize(content));
        };
      })(this));
    };

    sanitize = function(html) {
      var attribute, attributesToRemove, o, _i, _len;
      o = cheerio.load("<div>" + html + "</div>");
      o('script').remove();
      attributesToRemove = ['onabort', 'onblur', 'onchange', 'onclick', 'ondbclick', 'onerror', 'onfocus', 'onkeydown', 'onkeypress', 'onkeyup', 'onload', 'onmousedown', 'onmousemove', 'onmouseover', 'onmouseout', 'onmouseup', 'onreset', 'onresize', 'onscroll', 'onselect', 'onsubmit', 'onunload'];
      for (_i = 0, _len = attributesToRemove.length; _i < _len; _i++) {
        attribute = attributesToRemove[_i];
        o('*').removeAttr(attribute);
      }
      return o.html();
    };

    return PackageReadmeView;

  })(View);

}).call(this);
