(function() {
  var $$$, PackageSnippetsView, Subscriber, View, path, _, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  path = require('path');

  _ = require('underscore-plus');

  _ref = require('atom-space-pen-views'), $$$ = _ref.$$$, View = _ref.View;

  Subscriber = require('emissary').Subscriber;

  module.exports = PackageSnippetsView = (function(_super) {
    __extends(PackageSnippetsView, _super);

    function PackageSnippetsView() {
      return PackageSnippetsView.__super__.constructor.apply(this, arguments);
    }

    Subscriber.includeInto(PackageSnippetsView);

    PackageSnippetsView.content = function() {
      return this.section({
        "class": 'section'
      }, (function(_this) {
        return function() {
          _this.div({
            "class": 'section-heading icon icon-code'
          }, 'Snippets');
          return _this.table({
            "class": 'package-snippets-table table native-key-bindings text',
            tabindex: -1
          }, function() {
            _this.thead(function() {
              return _this.tr(function() {
                _this.th('Trigger');
                _this.th('Name');
                return _this.th('Body');
              });
            });
            return _this.tbody({
              outlet: 'snippets'
            });
          });
        };
      })(this));
    };

    PackageSnippetsView.prototype.initialize = function(packagePath) {
      this.packagePath = path.join(packagePath, path.sep);
      this.hide();
      return this.addSnippets();
    };

    PackageSnippetsView.prototype.detached = function() {
      return this.unsubscribe();
    };

    PackageSnippetsView.prototype.getSnippetProperties = function() {
      var name, packageProperties, properties, snippet, _i, _len, _ref1, _ref2, _ref3, _ref4;
      packageProperties = {};
      _ref1 = atom.config.scopedSettingsStore.propertySets;
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        _ref2 = _ref1[_i], name = _ref2.name, properties = _ref2.properties;
        if ((name != null ? typeof name.indexOf === "function" ? name.indexOf(this.packagePath) : void 0 : void 0) !== 0) {
          continue;
        }
        _ref4 = (_ref3 = properties.snippets) != null ? _ref3 : {};
        for (name in _ref4) {
          snippet = _ref4[name];
          if (snippet != null) {
            if (packageProperties[name] == null) {
              packageProperties[name] = snippet;
            }
          }
        }
      }
      return _.values(packageProperties).sort(function(snippet1, snippet2) {
        var prefix1, prefix2, _ref5, _ref6;
        prefix1 = (_ref5 = snippet1.prefix) != null ? _ref5 : '';
        prefix2 = (_ref6 = snippet2.prefix) != null ? _ref6 : '';
        return prefix1.localeCompare(prefix2);
      });
    };

    PackageSnippetsView.prototype.getSnippets = function(callback) {
      var snippetsModule, snippetsPackage;
      snippetsPackage = atom.packages.getLoadedPackage('snippets');
      if (snippetsModule = snippetsPackage != null ? snippetsPackage.mainModule : void 0) {
        if (snippetsModule.loaded) {
          return callback(this.getSnippetProperties());
        } else {
          return snippetsModule.onDidLoadSnippets((function(_this) {
            return function() {
              return callback(_this.getSnippetProperties());
            };
          })(this));
        }
      } else {
        return callback([]);
      }
    };

    PackageSnippetsView.prototype.addSnippets = function() {
      return this.getSnippets((function(_this) {
        return function(snippets) {
          var bodyText, name, prefix, _i, _len, _ref1, _ref2;
          _this.snippets.empty();
          for (_i = 0, _len = snippets.length; _i < _len; _i++) {
            _ref1 = snippets[_i], bodyText = _ref1.bodyText, name = _ref1.name, prefix = _ref1.prefix;
            if (name == null) {
              name = '';
            }
            if (prefix == null) {
              prefix = '';
            }
            bodyText = (_ref2 = bodyText != null ? bodyText.replace(/\t/g, '\\t').replace(/\n/g, '\\n') : void 0) != null ? _ref2 : '';
            _this.snippets.append($$$(function() {
              return this.tr((function(_this) {
                return function() {
                  _this.td({
                    "class": 'snippet-prefix'
                  }, prefix);
                  _this.td(name);
                  return _this.td({
                    "class": 'snippet-body'
                  }, bodyText);
                };
              })(this));
            }));
          }
          if (_this.snippets.children().length > 0) {
            return _this.show();
          } else {
            return _this.hide();
          }
        };
      })(this));
    };

    return PackageSnippetsView;

  })(View);

}).call(this);
