(function() {
  var PackageUpdateView, Subscriber, View, _,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ = require('underscore-plus');

  View = require('atom-space-pen-views').View;

  Subscriber = require('emissary').Subscriber;

  module.exports = PackageUpdateView = (function(_super) {
    __extends(PackageUpdateView, _super);

    function PackageUpdateView() {
      return PackageUpdateView.__super__.constructor.apply(this, arguments);
    }

    Subscriber.includeInto(PackageUpdateView);

    PackageUpdateView.content = function(_arg) {
      var description, name;
      name = _arg.name, description = _arg.description;
      return this.div({
        "class": 'col-md-6 package-update-view'
      }, (function(_this) {
        return function() {
          return _this.div({
            outlet: 'thumbnail',
            "class": 'thumbnail text'
          }, function() {
            return _this.div({
              "class": 'caption'
            }, function() {
              _this.span({
                outlet: 'status',
                "class": 'package-status icon'
              });
              _this.h4({
                "class": 'package-name native-key-bindings',
                tabindex: -1
              }, _.undasherize(_.uncamelcase(name)));
              _this.p({
                outlet: 'latestVersion',
                "class": 'description native-key-bindings',
                tabindex: -1
              });
              return _this.div({
                "class": 'btn-toolbar'
              }, function() {
                _this.button({
                  outlet: 'upgradeButton',
                  "class": 'btn btn-primary upgrade-button'
                }, 'Update');
                _this.button({
                  outlet: 'uninstallButton',
                  "class": 'btn btn-default'
                }, 'Uninstall');
                return _this.button({
                  outlet: 'settingsButton',
                  "class": 'btn btn-default'
                }, 'Settings');
              });
            });
          });
        };
      })(this));
    };

    PackageUpdateView.prototype.initialize = function(pack, packageManager) {
      this.pack = pack;
      this.packageManager = packageManager;
      this.type = this.pack.theme ? 'theme' : 'package';
      this.latestVersion.html("Version <span class='highlight'>" + this.pack.latestVersion + "</span> is now available. " + this.pack.version + " is currently installed.");
      this.handlePackageEvents();
      this.upgradeButton.on('click', (function(_this) {
        return function() {
          return _this.upgrade();
        };
      })(this));
      this.uninstallButton.on('click', (function(_this) {
        return function() {
          return _this.uninstall();
        };
      })(this));
      return this.settingsButton.on('click', (function(_this) {
        return function() {
          var _ref;
          return (_ref = _this.parents('.settings-view').view()) != null ? _ref.showPanel(_this.pack.name, {
            back: 'Available Updates'
          }) : void 0;
        };
      })(this));
    };

    PackageUpdateView.prototype.detached = function() {
      var _ref;
      if ((_ref = this.statusTooltip) != null) {
        _ref.dispose();
      }
      return this.unsubscribe();
    };

    PackageUpdateView.prototype.handlePackageEvents = function() {
      this.subscribeToPackageEvent('package-updated theme-updated package-update-failed theme-update-failed', (function(_this) {
        return function(pack, error) {
          if (error != null) {
            _this.setButtonsEnabled(true);
            _this.setStatusIcon('alert');
            return _this.setUpgradeButton();
          } else {
            _this.uninstallButton.prop('disabled', false);
            _this.latestVersion.text("Version " + _this.pack.latestVersion + " is now installed.");
            _this.setStatusIcon('check');
            return _this.setUpgradeButton('check');
          }
        };
      })(this));
      this.subscribeToPackageEvent('package-updating', (function(_this) {
        return function(pack) {
          _this.setButtonsEnabled(false);
          _this.setStatusIcon('cloud-download');
          return _this.setUpgradeButton('cloud-download');
        };
      })(this));
      this.subscribeToPackageEvent('package-uninstalling', (function(_this) {
        return function(pack) {
          _this.setButtonsEnabled(false);
          _this.setStatusIcon();
          return _this.setUpgradeButton();
        };
      })(this));
      return this.subscribeToPackageEvent('package-uninstalled package-uninstall-failed theme-uninstalled theme-uninstall-failed', (function(_this) {
        return function(pack, error) {
          if (error != null) {
            _this.setButtonsEnabled(true);
            _this.setStatusIcon('alert');
            return _this.setUpgradeButton();
          }
        };
      })(this));
    };

    PackageUpdateView.prototype.setButtonsEnabled = function(enabled) {
      this.upgradeButton.prop('disabled', !enabled);
      return this.uninstallButton.prop('disabled', !enabled);
    };

    PackageUpdateView.prototype.subscribeToPackageEvent = function(event, callback) {
      return this.subscribe(this.packageManager, event, (function(_this) {
        return function(pack, error) {
          if (pack.name === _this.pack.name) {
            return callback(pack, error);
          }
        };
      })(this));
    };

    PackageUpdateView.prototype.uninstall = function() {
      this.packageManager.emit('package-uninstalling', this.pack);
      return this.packageManager.uninstall(this.pack, (function(_this) {
        return function(error) {
          var _ref;
          if (error != null) {
            return console.error("Uninstalling " + _this.type + " " + _this.pack.name + " failed", (_ref = error.stack) != null ? _ref : error, error.stderr);
          }
        };
      })(this));
    };

    PackageUpdateView.prototype.upgrade = function() {
      if (this.upgradeButton.prop('disabled')) {
        return;
      }
      return this.packageManager.update(this.pack, this.pack.latestVersion, (function(_this) {
        return function(error) {
          var _ref;
          if (error != null) {
            return console.error("Upgrading " + _this.type + " " + _this.pack.name + " failed", (_ref = error.stack) != null ? _ref : error, error.stderr);
          }
        };
      })(this));
    };

    PackageUpdateView.prototype.setStatusIcon = function(iconName) {
      var tooltip, _ref;
      this.status.removeClass('icon-check icon-alert icon-cloud-download');
      if (iconName) {
        this.status.addClass("icon-" + iconName);
      }
      if ((_ref = this.statusTooltip) != null) {
        _ref.dispose();
      }
      switch (iconName) {
        case 'check':
          tooltip = _.capitalize("" + this.type + " updated");
          break;
        case 'alert':
          tooltip = _.capitalize("" + this.type + " failed to update");
          break;
        case 'cloud-download':
          tooltip = _.capitalize("" + this.type + " updating");
      }
      if (tooltip) {
        return this.statusTooltip = atom.tooltips.add(this.status[0], {
          title: tooltip
        });
      }
    };

    PackageUpdateView.prototype.setUpgradeButton = function(iconName) {
      this.upgradeButton.removeClass('btn-primary btn-progress btn-success icon icon-check icon-alert icon-cloud-download');
      if (iconName) {
        this.upgradeButton.addClass("icon icon-" + iconName);
      }
      switch (iconName) {
        case void 0:
          this.upgradeButton.addClass('btn-primary');
          return this.upgradeButton.text('Update');
        case 'cloud-download':
          this.upgradeButton.addClass('btn-progress');
          return this.upgradeButton.text('Updating...');
        case 'check':
          this.upgradeButton.addClass('btn-success');
          return this.upgradeButton.text('Updated');
      }
    };

    return PackageUpdateView;

  })(View);

}).call(this);
