(function() {
  var PackageUpdatesStatusView, View, _,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ = require('underscore-plus');

  View = require('atom-space-pen-views').View;

  module.exports = PackageUpdatesStatusView = (function(_super) {
    __extends(PackageUpdatesStatusView, _super);

    function PackageUpdatesStatusView() {
      return PackageUpdatesStatusView.__super__.constructor.apply(this, arguments);
    }

    PackageUpdatesStatusView.content = function() {
      return this.div({
        "class": 'package-updates-status-view inline-block text text-info'
      }, (function(_this) {
        return function() {
          _this.span({
            "class": 'icon icon-package'
          });
          return _this.span({
            outlet: 'countLabel',
            "class": 'available-updates-status'
          });
        };
      })(this));
    };

    PackageUpdatesStatusView.prototype.initialize = function(statusBar, packages) {
      this.countLabel.text(packages.length);
      this.tooltip = atom.tooltips.add(this.element, {
        title: "" + (_.pluralize(packages.length, 'package update')) + " available"
      });
      this.tile = statusBar.addRightTile({
        item: this,
        priority: 0
      });
      return this.on('click', (function(_this) {
        return function() {
          atom.commands.dispatch(atom.views.getView(atom.workspace), 'settings-view:check-for-package-updates');
          _this.tooltip.dispose();
          return _this.tile.destroy();
        };
      })(this));
    };

    return PackageUpdatesStatusView;

  })(View);

}).call(this);
