(function() {
  var $, $$, CSON, Client, Disposable, GeneralPanel, InstallPanel, InstalledPackagesPanel, KeybindingsPanel, PackageDetailView, PackageManager, ScrollView, SettingsView, Subscriber, TextEditorView, ThemesPanel, UpdatesPanel, async, fuzzaldrin, path, _, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  path = require('path');

  _ = require('underscore-plus');

  _ref = require('atom-space-pen-views'), $ = _ref.$, $$ = _ref.$$, ScrollView = _ref.ScrollView, TextEditorView = _ref.TextEditorView;

  Disposable = require('atom').Disposable;

  Subscriber = require('emissary').Subscriber;

  async = require('async');

  CSON = require('season');

  fuzzaldrin = require('fuzzaldrin');

  Client = require('./atom-io-client');

  GeneralPanel = require('./general-panel');

  PackageDetailView = require('./package-detail-view');

  KeybindingsPanel = require('./keybindings-panel');

  PackageManager = require('./package-manager');

  InstallPanel = require('./install-panel');

  ThemesPanel = require('./themes-panel');

  InstalledPackagesPanel = require('./installed-packages-panel');

  UpdatesPanel = require('./updates-panel');

  module.exports = SettingsView = (function(_super) {
    __extends(SettingsView, _super);

    function SettingsView() {
      return SettingsView.__super__.constructor.apply(this, arguments);
    }

    Subscriber.includeInto(SettingsView);

    SettingsView.content = function() {
      return this.div({
        "class": 'settings-view pane-item',
        tabindex: -1
      }, (function(_this) {
        return function() {
          _this.div({
            "class": 'config-menu',
            outlet: 'sidebar'
          }, function() {
            _this.ul({
              "class": 'panels-menu nav nav-pills nav-stacked',
              outlet: 'panelMenu'
            }, function() {
              return _this.div({
                "class": 'panel-menu-separator',
                outlet: 'menuSeparator'
              });
            });
            return _this.div({
              "class": 'button-area'
            }, function() {
              return _this.button({
                "class": 'btn btn-default icon icon-link-external',
                outlet: 'openDotAtom'
              }, 'Open Config Folder');
            });
          });
          return _this.div({
            "class": 'panels',
            outlet: 'panels'
          });
        };
      })(this));
    };

    SettingsView.prototype.initialize = function(_arg) {
      var activePanelName, _ref1;
      _ref1 = _arg != null ? _arg : {}, this.uri = _ref1.uri, activePanelName = _ref1.activePanelName;
      SettingsView.__super__.initialize.apply(this, arguments);
      this.packageManager = new PackageManager();
      this.handlePackageEvents();
      this.panelToShow = activePanelName;
      return process.nextTick((function(_this) {
        return function() {
          return _this.initializePanels();
        };
      })(this));
    };

    SettingsView.prototype.detached = function() {
      return this.unsubscribe();
    };

    SettingsView.prototype.onDidChangeTitle = function() {
      return new Disposable();
    };

    SettingsView.prototype.onDidChangeModified = function() {
      return new Disposable();
    };

    SettingsView.prototype.handlePackageEvents = function() {
      return this.subscribe(this.packageManager, 'package-installed theme-installed', (function(_this) {
        return function(_arg) {
          var name, pack;
          name = _arg.name;
          if (pack = atom.packages.getLoadedPackage(name)) {
            return _this.addPackagePanel(pack);
          }
        };
      })(this));
    };

    SettingsView.prototype.initializePanels = function() {
      var pack, _i, _len, _ref1;
      if (this.panels.size > 0) {
        return;
      }
      this.panelsByName = {};
      this.on('click', '.panels-menu li a, .panels-packages li a', (function(_this) {
        return function(e) {
          return _this.showPanel($(e.target).closest('li').attr('name'));
        };
      })(this));
      this.openDotAtom.on('click', function() {
        return atom.open({
          pathsToOpen: [atom.getConfigDirPath()]
        });
      });
      this.addCorePanel('Settings', 'settings', function() {
        return new GeneralPanel;
      });
      this.addCorePanel('Keybindings', 'keyboard', function() {
        return new KeybindingsPanel;
      });
      this.addCorePanel('Packages', 'package', (function(_this) {
        return function() {
          return new InstalledPackagesPanel(_this.packageManager);
        };
      })(this));
      this.addCorePanel('Themes', 'paintcan', (function(_this) {
        return function() {
          return new ThemesPanel(_this.packageManager);
        };
      })(this));
      this.addCorePanel('Updates', 'cloud-download', (function(_this) {
        return function() {
          return new UpdatesPanel(_this.packageManager);
        };
      })(this));
      this.addCorePanel('Install', 'plus', (function(_this) {
        return function() {
          return new InstallPanel(_this.packageManager);
        };
      })(this));
      _ref1 = this.getPackages();
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        pack = _ref1[_i];
        this.addPackagePanel(pack);
      }
      if (this.panelToShow) {
        this.showPanel(this.panelToShow);
      }
      if (!this.activePanelName) {
        this.showPanel('Settings');
      }
      if (this.isOnDom()) {
        return this.sidebar.width(this.sidebar.width());
      }
    };

    SettingsView.prototype.serialize = function() {
      var _ref1;
      return {
        deserializer: 'SettingsView',
        version: 2,
        activePanelName: (_ref1 = this.activePanelName) != null ? _ref1 : this.panelToShow,
        uri: this.uri
      };
    };

    SettingsView.prototype.getPackages = function() {
      var bundledPackageMetadataCache, error, metadata, name, packageName, packagePath, _i, _len, _ref1, _ref2, _ref3, _ref4, _ref5;
      if (this.packages != null) {
        return this.packages;
      }
      this.packages = atom.packages.getLoadedPackages();
      try {
        bundledPackageMetadataCache = (_ref1 = require(path.join(atom.getLoadSettings().resourcePath, 'package.json'))) != null ? _ref1._atomPackages : void 0;
      } catch (_error) {}
      _ref3 = (_ref2 = atom.config.get('core.disabledPackages')) != null ? _ref2 : [];
      for (_i = 0, _len = _ref3.length; _i < _len; _i++) {
        packageName = _ref3[_i];
        packagePath = atom.packages.resolvePackagePath(packageName);
        if (!packagePath) {
          continue;
        }
        try {
          metadata = require(path.join(packagePath, 'package.json'));
        } catch (_error) {
          error = _error;
          metadata = bundledPackageMetadataCache != null ? (_ref4 = bundledPackageMetadataCache[packageName]) != null ? _ref4.metadata : void 0 : void 0;
        }
        if (metadata == null) {
          continue;
        }
        name = (_ref5 = metadata.name) != null ? _ref5 : packageName;
        if (!_.findWhere(this.packages, {
          name: name
        })) {
          this.packages.push({
            name: name,
            metadata: metadata,
            path: packagePath
          });
        }
      }
      this.packages.sort((function(_this) {
        return function(pack1, pack2) {
          var title1, title2;
          title1 = _this.packageManager.getPackageTitle(pack1);
          title2 = _this.packageManager.getPackageTitle(pack2);
          return title1.localeCompare(title2);
        };
      })(this));
      return this.packages;
    };

    SettingsView.prototype.addCorePanel = function(name, iconName, panel) {
      var panelMenuItem;
      panelMenuItem = $$(function() {
        return this.li({
          name: name
        }, (function(_this) {
          return function() {
            return _this.a({
              "class": "icon icon-" + iconName
            }, name);
          };
        })(this));
      });
      this.menuSeparator.before(panelMenuItem);
      return this.addPanel(name, panelMenuItem, panel);
    };

    SettingsView.prototype.addPackagePanel = function(pack) {
      return this.addPanel(pack.name, null, (function(_this) {
        return function() {
          return new PackageDetailView(pack, _this.packageManager);
        };
      })(this));
    };

    SettingsView.prototype.addPanel = function(name, panelMenuItem, panelCreateCallback) {
      if (this.panelCreateCallbacks == null) {
        this.panelCreateCallbacks = {};
      }
      this.panelCreateCallbacks[name] = panelCreateCallback;
      if (this.panelToShow === name) {
        return this.showPanel(name);
      }
    };

    SettingsView.prototype.getOrCreatePanel = function(name, opts) {
      var callback, panel, _ref1, _ref2;
      panel = (_ref1 = this.panelsByName) != null ? _ref1[name] : void 0;
      if (panel == null) {
        callback = (_ref2 = this.panelCreateCallbacks) != null ? _ref2[name] : void 0;
        if ((opts != null ? opts.pack : void 0) && !callback) {
          callback = (function(_this) {
            return function() {
              opts.pack.metadata = opts.pack;
              return new PackageDetailView(opts.pack, _this.packageManager);
            };
          })(this);
        }
        if (callback) {
          panel = callback();
          if (this.panelsByName == null) {
            this.panelsByName = {};
          }
          this.panelsByName[name] = panel;
          delete this.panelCreateCallbacks[name];
        }
      }
      return panel;
    };

    SettingsView.prototype.makePanelMenuActive = function(name) {
      this.sidebar.find('.active').removeClass('active');
      return this.sidebar.find("[name='" + name + "']").addClass('active');
    };

    SettingsView.prototype.focus = function() {
      var child, panel, view, _i, _len, _ref1;
      SettingsView.__super__.focus.apply(this, arguments);
      _ref1 = this.panels.children();
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        panel = _ref1[_i];
        child = $(panel);
        if (child.isVisible()) {
          if (view = child.view()) {
            view.focus();
          } else {
            child.focus();
          }
          return;
        }
      }
    };

    SettingsView.prototype.showPanel = function(name, opts) {
      var panel;
      if (panel = this.getOrCreatePanel(name, opts)) {
        this.panels.children().hide();
        if (!$.contains(this.panels[0], panel[0])) {
          this.panels.append(panel);
        }
        if (typeof panel.beforeShow === "function") {
          panel.beforeShow(opts);
        }
        panel.show();
        panel.focus();
        this.makePanelMenuActive(name);
        this.activePanelName = name;
        return this.panelToShow = null;
      } else {
        return this.panelToShow = name;
      }
    };

    SettingsView.prototype.removePanel = function(name) {
      var panel, _ref1;
      if (panel = (_ref1 = this.panelsByName) != null ? _ref1[name] : void 0) {
        panel.remove();
        return delete this.panelsByName[name];
      }
    };

    SettingsView.prototype.getTitle = function() {
      return "Settings";
    };

    SettingsView.prototype.getIconName = function() {
      return "tools";
    };

    SettingsView.prototype.getURI = function() {
      return this.uri;
    };

    SettingsView.prototype.isEqual = function(other) {
      return other instanceof SettingsView;
    };

    return SettingsView;

  })(ScrollView);

}).call(this);
