(function() {
  var $$, CompositeDisposable, ErrorView, PackageCard, PackageManager, Subscriber, TextEditorView, ThemesPanel, View, fs, fuzzaldrin, path, _, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  path = require('path');

  fs = require('fs-plus');

  fuzzaldrin = require('fuzzaldrin');

  _ = require('underscore-plus');

  CompositeDisposable = require('atom').CompositeDisposable;

  _ref = require('atom-space-pen-views'), $$ = _ref.$$, TextEditorView = _ref.TextEditorView, View = _ref.View;

  Subscriber = require('emissary').Subscriber;

  PackageCard = require('./package-card');

  ErrorView = require('./error-view');

  PackageManager = require('./package-manager');

  module.exports = ThemesPanel = (function(_super) {
    __extends(ThemesPanel, _super);

    function ThemesPanel() {
      return ThemesPanel.__super__.constructor.apply(this, arguments);
    }

    Subscriber.includeInto(ThemesPanel);

    ThemesPanel.content = function() {
      return this.div((function(_this) {
        return function() {
          _this.div({
            "class": 'section packages themes-panel'
          }, function() {
            return _this.div({
              "class": 'section-container'
            }, function() {
              _this.div({
                "class": 'section-heading icon icon-device-desktop'
              }, 'Choose a Theme');
              _this.div({
                "class": 'text native-key-bindings',
                tabindex: -1
              }, function() {
                _this.span({
                  "class": 'icon icon-question'
                }, 'You can also style Atom by editing ');
                return _this.a({
                  "class": 'link',
                  outlet: 'openUserStysheet'
                }, 'your stylesheet');
              });
              return _this.div({
                "class": 'themes-picker'
              }, function() {
                _this.div({
                  "class": 'themes-picker-item control-group'
                }, function() {
                  return _this.div({
                    "class": 'controls'
                  }, function() {
                    _this.label({
                      "class": 'control-label'
                    }, function() {
                      _this.div({
                        "class": 'setting-title themes-label text'
                      }, 'UI Theme');
                      return _this.div({
                        "class": 'setting-description text theme-description'
                      }, 'This styles the tabs, status bar, tree view, and dropdowns');
                    });
                    return _this.select({
                      outlet: 'uiMenu',
                      "class": 'form-control'
                    });
                  });
                });
                return _this.div({
                  "class": 'themes-picker-item control-group'
                }, function() {
                  return _this.div({
                    "class": 'controls'
                  }, function() {
                    _this.label({
                      "class": 'control-label'
                    }, function() {
                      _this.div({
                        "class": 'setting-title themes-label text'
                      }, 'Syntax Theme');
                      return _this.div({
                        "class": 'setting-description text theme-description'
                      }, 'This styles the text inside the editor');
                    });
                    return _this.select({
                      outlet: 'syntaxMenu',
                      "class": 'form-control'
                    });
                  });
                });
              });
            });
          });
          return _this.section({
            "class": 'section'
          }, function() {
            return _this.div({
              "class": 'section-container'
            }, function() {
              _this.div({
                "class": 'section-heading icon icon-paintcan'
              }, function() {
                _this.text('Installed Themes');
                return _this.span({
                  outlet: 'totalPackages',
                  "class": 'section-heading-count badge badge-flexible'
                }, '…');
              });
              _this.div({
                "class": 'editor-container'
              }, function() {
                return _this.subview('filterEditor', new TextEditorView({
                  mini: true,
                  placeholderText: 'Filter themes by name'
                }));
              });
              _this.div({
                outlet: 'themeErrors'
              });
              _this.section({
                "class": 'sub-section installed-packages'
              }, function() {
                _this.h3({
                  "class": 'sub-section-heading icon icon-paintcan'
                }, function() {
                  _this.text('Community Themes');
                  return _this.span({
                    outlet: 'communityCount',
                    "class": 'section-heading-count badge badge-flexible'
                  }, '…');
                });
                return _this.div({
                  outlet: 'communityPackages',
                  "class": 'container package-container'
                }, function() {
                  return _this.div({
                    "class": 'alert alert-info loading-area icon icon-hourglass'
                  }, "Loading themes…");
                });
              });
              _this.section({
                "class": 'sub-section core-packages'
              }, function() {
                _this.h3({
                  "class": 'sub-section-heading icon icon-paintcan'
                }, function() {
                  _this.text('Core Themes');
                  return _this.span({
                    outlet: 'coreCount',
                    "class": 'section-heading-count badge badge-flexible'
                  }, '…');
                });
                return _this.div({
                  outlet: 'corePackages',
                  "class": 'container package-container'
                }, function() {
                  return _this.div({
                    "class": 'alert alert-info loading-area icon icon-hourglass'
                  }, "Loading themes…");
                });
              });
              return _this.section({
                "class": 'sub-section dev-packages'
              }, function() {
                _this.h3({
                  "class": 'sub-section-heading icon icon-paintcan'
                }, function() {
                  _this.text('Development Themes');
                  return _this.span({
                    outlet: 'devCount',
                    "class": 'section-heading-count badge badge-flexible'
                  }, '…');
                });
                return _this.div({
                  outlet: 'devPackages',
                  "class": 'container package-container'
                }, function() {
                  return _this.div({
                    "class": 'alert alert-info loading-area icon icon-hourglass'
                  }, "Loading themes…");
                });
              });
            });
          });
        };
      })(this));
    };

    ThemesPanel.prototype.initialize = function(packageManager) {
      this.packageManager = packageManager;
      this.disposables = new CompositeDisposable();
      this.packageViews = [];
      this.loadPackages();
      this.subscribe(this.packageManager, 'theme-install-failed theme-uninstall-failed', (function(_this) {
        return function(pack, error) {
          return _this.themeErrors.append(new ErrorView(_this.packageManager, error));
        };
      })(this));
      this.openUserStysheet.on('click', (function(_this) {
        return function() {
          atom.commands.dispatch(atom.views.getView(atom.workspace), 'application:open-your-stylesheet');
          return false;
        };
      })(this));
      this.subscribe(this.packageManager, 'theme-installed theme-uninstalled', (function(_this) {
        return function() {
          return _this.populateThemeMenus();
        };
      })(this));
      this.disposables.add(atom.themes.onDidChangeActiveThemes((function(_this) {
        return function() {
          return _this.updateActiveThemes();
        };
      })(this)));
      this.updateActiveThemes();
      this.filterEditor.getModel().onDidStopChanging((function(_this) {
        return function() {
          return _this.matchPackages();
        };
      })(this));
      this.syntaxMenu.change((function(_this) {
        return function() {
          _this.activeSyntaxTheme = _this.syntaxMenu.val();
          return _this.scheduleUpdateThemeConfig();
        };
      })(this));
      return this.uiMenu.change((function(_this) {
        return function() {
          _this.activeUiTheme = _this.uiMenu.val();
          return _this.scheduleUpdateThemeConfig();
        };
      })(this));
    };

    ThemesPanel.prototype.focus = function() {
      return this.filterEditor.focus();
    };

    ThemesPanel.prototype.detached = function() {
      this.unsubscribe();
      return this.disposables.dispose();
    };

    ThemesPanel.prototype.filterThemes = function(packages) {
      packages.dev = packages.dev.filter(function(_arg) {
        var theme;
        theme = _arg.theme;
        return theme;
      });
      packages.user = packages.user.filter(function(_arg) {
        var theme;
        theme = _arg.theme;
        return theme;
      });
      packages.core = packages.core.filter(function(_arg) {
        var theme;
        theme = _arg.theme;
        return theme;
      });
      return packages;
    };

    ThemesPanel.prototype.loadPackages = function() {
      this.packageViews = [];
      return this.packageManager.getInstalled().then((function(_this) {
        return function(packages) {
          _this.packages = _this.filterThemes(packages);
          _this.totalPackages.text("" + (_this.packages.user.length + _this.packages.core.length + _this.packages.dev.length));
          _.each(_this.addPackageViews(_this.communityPackages, _this.packages.user), function(v) {
            return _this.packageViews.push(v);
          });
          _this.communityCount.text("" + _this.packages.user.length);
          _this.packages.core = _this.packages.core.map(function(p) {
            if (!p.repository) {
              p.repository = "https://github.com/atom/" + p.name;
            }
            return p;
          });
          _.each(_this.addPackageViews(_this.corePackages, _this.packages.core), function(v) {
            return _this.packageViews.push(v);
          });
          _this.coreCount.text("" + _this.packages.core.length);
          _.each(_this.addPackageViews(_this.devPackages, _this.packages.dev), function(v) {
            return _this.packageViews.push(v);
          });
          return _this.devCount.text("" + _this.packages.dev.length);
        };
      })(this))["catch"]((function(_this) {
        return function(error) {
          _this.loadingMessage.hide();
          return _this.themeErrors.append(new ErrorView(_this.packageManager, error));
        };
      })(this));
    };

    ThemesPanel.prototype.updateActiveThemes = function() {
      this.activeUiTheme = this.getActiveUiTheme();
      this.activeSyntaxTheme = this.getActiveSyntaxTheme();
      return this.populateThemeMenus();
    };

    ThemesPanel.prototype.populateThemeMenus = function() {
      var availableThemes, metadata, name, themeItem, _i, _len, _ref1, _results;
      this.uiMenu.empty();
      this.syntaxMenu.empty();
      availableThemes = _.sortBy(atom.themes.getLoadedThemes(), 'name');
      _results = [];
      for (_i = 0, _len = availableThemes.length; _i < _len; _i++) {
        _ref1 = availableThemes[_i], name = _ref1.name, metadata = _ref1.metadata;
        switch (metadata.theme) {
          case 'ui':
            themeItem = this.createThemeMenuItem(name);
            if (name === this.activeUiTheme) {
              themeItem.prop('selected', true);
            }
            _results.push(this.uiMenu.append(themeItem));
            break;
          case 'syntax':
            themeItem = this.createThemeMenuItem(name);
            if (name === this.activeSyntaxTheme) {
              themeItem.prop('selected', true);
            }
            _results.push(this.syntaxMenu.append(themeItem));
            break;
          default:
            _results.push(void 0);
        }
      }
      return _results;
    };

    ThemesPanel.prototype.getActiveUiTheme = function() {
      var metadata, name, _i, _len, _ref1, _ref2;
      _ref1 = atom.themes.getActiveThemes();
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        _ref2 = _ref1[_i], name = _ref2.name, metadata = _ref2.metadata;
        if (metadata.theme === 'ui') {
          return name;
        }
      }
      return null;
    };

    ThemesPanel.prototype.getActiveSyntaxTheme = function() {
      var metadata, name, _i, _len, _ref1, _ref2;
      _ref1 = atom.themes.getActiveThemes();
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        _ref2 = _ref1[_i], name = _ref2.name, metadata = _ref2.metadata;
        if (metadata.theme === 'syntax') {
          return name;
        }
      }
      return null;
    };

    ThemesPanel.prototype.updateThemeConfig = function() {
      var themes;
      themes = [];
      if (this.activeUiTheme) {
        themes.push(this.activeUiTheme);
      }
      if (this.activeSyntaxTheme) {
        themes.push(this.activeSyntaxTheme);
      }
      if (themes.length > 0) {
        return atom.config.set("core.themes", themes);
      }
    };

    ThemesPanel.prototype.scheduleUpdateThemeConfig = function() {
      return setTimeout(((function(_this) {
        return function() {
          return _this.updateThemeConfig();
        };
      })(this)), 100);
    };

    ThemesPanel.prototype.createThemeMenuItem = function(themeName) {
      var title;
      title = this.getThemeTitle(themeName);
      return $$(function() {
        return this.option({
          value: themeName
        }, title);
      });
    };

    ThemesPanel.prototype.getThemeTitle = function(themeName) {
      var title;
      if (themeName == null) {
        themeName = '';
      }
      title = themeName.replace(/-(ui|syntax)/g, '').replace(/-theme$/g, '');
      return _.undasherize(_.uncamelcase(title));
    };

    ThemesPanel.prototype.addPackageViews = function(container, packages) {
      var index, pack, packView, packageRow, packageViews, _i, _len;
      container.empty();
      packageViews = [];
      packages.sort(function(left, right) {
        var leftStatus, rightStatus;
        leftStatus = atom.packages.isPackageDisabled(left.name);
        rightStatus = atom.packages.isPackageDisabled(right.name);
        if (leftStatus === rightStatus) {
          return 0;
        } else if (leftStatus > rightStatus) {
          return 1;
        } else {
          return -1;
        }
      });
      for (index = _i = 0, _len = packages.length; _i < _len; index = ++_i) {
        pack = packages[index];
        packageRow = $$(function() {
          return this.div({
            "class": 'row'
          });
        });
        container.append(packageRow);
        packView = new PackageCard(pack, this.packageManager, {
          back: 'Themes'
        });
        packageViews.push(packView);
        packageRow.append(packView);
      }
      return packageViews;
    };

    ThemesPanel.prototype.filterPackageListByText = function(text) {
      var active;
      if (!this.packages) {
        return;
      }
      active = fuzzaldrin.filter(this.packageViews, text, {
        key: 'filterText'
      });
      _.each(this.packageViews, function(view) {
        return view.hide().addClass('hidden');
      });
      _.each(active, function(view) {
        return view.show().removeClass('hidden');
      });
      this.totalPackages.text("" + active.length + "/" + this.packageViews.length);
      return this.updateSectionCounts();
    };

    ThemesPanel.prototype.updateSectionCounts = function() {
      var community, core, dev, filterText;
      filterText = this.filterEditor.getModel().getText();
      if (filterText === '') {
        this.totalPackages.text("" + (this.packages.user.length + this.packages.core.length + this.packages.dev.length));
        this.communityCount.text("" + this.packages.user.length);
        this.coreCount.text("" + this.packages.core.length);
        return this.devCount.text("" + this.packages.dev.length);
      } else {
        community = this.communityPackages.find('.package-card:not(.hidden)').length;
        this.communityCount.text("" + community + "/" + this.packages.user.length);
        dev = this.devPackages.find('.package-card:not(.hidden)').length;
        this.devCount.text("" + dev + "/" + this.packages.dev.length);
        core = this.corePackages.find('.package-card:not(.hidden)').length;
        return this.coreCount.text("" + core + "/" + this.packages.core.length);
      }
    };

    ThemesPanel.prototype.matchPackages = function() {
      var filterText;
      filterText = this.filterEditor.getModel().getText();
      return this.filterPackageListByText(filterText);
    };

    return ThemesPanel;

  })(View);

}).call(this);
