(function() {
  var $, $$, ErrorView, PackageUpdateView, Subscriber, UpdatesPanel, View, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ref = require('atom-space-pen-views'), $ = _ref.$, $$ = _ref.$$, View = _ref.View;

  Subscriber = require('emissary').Subscriber;

  ErrorView = require('./error-view');

  PackageUpdateView = require('./package-update-view');

  module.exports = UpdatesPanel = (function(_super) {
    __extends(UpdatesPanel, _super);

    function UpdatesPanel() {
      return UpdatesPanel.__super__.constructor.apply(this, arguments);
    }

    Subscriber.includeInto(UpdatesPanel);

    UpdatesPanel.content = function() {
      return this.div((function(_this) {
        return function() {
          return _this.section({
            "class": 'section packages'
          }, function() {
            return _this.div({
              "class": 'section-container updates-container'
            }, function() {
              _this.h1({
                "class": 'section-heading icon icon-cloud-download'
              }, 'Available Updates', function() {
                return _this.button({
                  outlet: 'updateAllButton',
                  "class": 'pull-right update-all-button btn btn-primary'
                }, 'Update All');
              });
              _this.div({
                outlet: 'updateErrors'
              });
              _this.div({
                outlet: 'checkingMessage',
                "class": 'alert alert-info featured-message icon icon-hourglass'
              }, 'Checking for updates\u2026');
              _this.div({
                outlet: 'noUpdatesMessage',
                "class": 'alert alert-info featured-message icon icon-heart'
              }, 'All of your installed packages are up to date!');
              return _this.div({
                outlet: 'updatesContainer',
                "class": 'container package-container'
              });
            });
          });
        };
      })(this));
    };

    UpdatesPanel.prototype.initialize = function(packageManager) {
      this.packageManager = packageManager;
      this.noUpdatesMessage.hide();
      this.updateAllButton.hide();
      this.updateAllButton.on('click', (function(_this) {
        return function() {
          var updateView, _i, _len, _ref1, _ref2, _results;
          _this.updateAllButton.prop('disabled', true);
          _ref1 = _this.updatesContainer.find('.package-update-view');
          _results = [];
          for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
            updateView = _ref1[_i];
            _results.push((_ref2 = $(updateView).view()) != null ? typeof _ref2.upgrade === "function" ? _ref2.upgrade() : void 0 : void 0);
          }
          return _results;
        };
      })(this));
      this.checkForUpdates();
      return this.subscribe(this.packageManager, 'package-update-failed theme-update-failed', (function(_this) {
        return function(pack, error) {
          return _this.updateErrors.append(new ErrorView(_this.packageManager, error));
        };
      })(this));
    };

    UpdatesPanel.prototype.detached = function() {
      return this.unsubscribe();
    };

    UpdatesPanel.prototype.beforeShow = function(opts) {
      if (opts != null ? opts.back : void 0) {
        this.breadcrumb.text(opts.back).on('click', (function(_this) {
          return function() {
            var _ref1;
            return (_ref1 = _this.parents('.settings-view').view()) != null ? _ref1.showPanel(opts.back) : void 0;
          };
        })(this));
      }
      if (opts != null ? opts.updates : void 0) {
        this.availableUpdates = opts.updates;
        return this.addUpdateViews();
      } else {
        this.availableUpdates = [];
        this.updatesContainer.empty();
        return this.checkForUpdates();
      }
    };

    UpdatesPanel.prototype.checkForUpdates = function() {
      this.noUpdatesMessage.hide();
      this.updateAllButton.hide();
      this.checkingMessage.show();
      return this.packageManager.getOutdated().then((function(_this) {
        return function(availableUpdates) {
          _this.availableUpdates = availableUpdates;
          return _this.addUpdateViews();
        };
      })(this))["catch"]((function(_this) {
        return function(error) {
          _this.checkingMessage.hide();
          return _this.updateErrors.append(new ErrorView(_this.packageManager, error));
        };
      })(this));
    };

    UpdatesPanel.prototype.addUpdateViews = function() {
      var index, pack, packageRow, _i, _len, _ref1, _results;
      if (this.availableUpdates.length > 0) {
        this.updateAllButton.show();
      }
      this.checkingMessage.hide();
      this.updatesContainer.empty();
      if (this.availableUpdates.length === 0) {
        this.noUpdatesMessage.show();
      }
      _ref1 = this.availableUpdates;
      _results = [];
      for (index = _i = 0, _len = _ref1.length; _i < _len; index = ++_i) {
        pack = _ref1[index];
        if (index % 2 === 0) {
          packageRow = $$(function() {
            return this.div({
              "class": 'row'
            });
          });
          this.updatesContainer.append(packageRow);
        }
        _results.push(packageRow.append(new PackageUpdateView(pack, this.packageManager)));
      }
      return _results;
    };

    return UpdatesPanel;

  })(View);

}).call(this);
