(function() {
  var AtomIoClient;

  AtomIoClient = require('../lib/atom-io-client');

  describe("AtomIoClient", function() {
    beforeEach(function() {
      return this.client = new AtomIoClient;
    });
    it("fetches avatar from cache if the network is unavailable", function() {
      spyOn(this.client, 'online').andReturn(false);
      spyOn(this.client, 'fetchAndCacheAvatar');
      expect(this.client.fetchAndCacheAvatar).not.toHaveBeenCalled();
      return this.client.avatar('test-user', function() {});
    });
    it("fetches api json from cache if the network is unavailable", function() {
      spyOn(this.client, 'online').andReturn(false);
      spyOn(this.client, 'fetchFromCache').andCallFake(function(path, opts, cb) {
        return cb(null, {});
      });
      spyOn(this.client, 'request');
      this.client["package"]('test-package', function() {});
      expect(this.client.fetchFromCache).toHaveBeenCalled();
      return expect(this.client.request).not.toHaveBeenCalled();
    });
    return xit("purges old items from cache correctly");
  });

}).call(this);
