(function() {
  var PackageCard;

  PackageCard = require('../lib/package-card');

  describe("PackageCard", function() {
    var setPackageStatusSpies;
    setPackageStatusSpies = function(opts) {
      spyOn(PackageCard.prototype, 'isInstalled').andReturn(opts.installed);
      spyOn(PackageCard.prototype, 'isDisabled').andReturn(opts.disabled);
      return spyOn(PackageCard.prototype, 'hasSettings').andReturn(opts.hasSettings);
    };
    beforeEach(function() {
      this.packageManager = jasmine.createSpyObj('packageManager', ['on', 'getClient', 'emit', 'install', 'uninstall']);
      return this.packageManager.getClient.andCallFake(function() {
        return jasmine.createSpyObj('client', ['avatar', 'package']);
      });
    });
    it("doesn't show the disable control for a theme", function() {
      var view;
      setPackageStatusSpies({
        installed: true,
        disabled: false
      });
      view = new PackageCard({
        theme: 'syntax',
        name: 'test-theme'
      }, this.packageManager);
      return expect(view.find.enablementButton).not.toExist();
    });
    it("doesn't show the status indicator for a theme", function() {
      var view;
      setPackageStatusSpies({
        installed: true,
        disabled: false
      });
      view = new PackageCard({
        theme: 'syntax',
        name: 'test-theme'
      }, this.packageManager);
      return expect(view.find.statusIndicatorButton).not.toExist();
    });
    it("doesn't show the settings button for a theme", function() {
      var view;
      setPackageStatusSpies({
        installed: true,
        disabled: false
      });
      view = new PackageCard({
        theme: 'syntax',
        name: 'test-theme'
      }, this.packageManager);
      return expect(view.find.settingsButton).not.toExist();
    });
    it("can be disabled if installed", function() {
      var view;
      setPackageStatusSpies({
        installed: true,
        disabled: false
      });
      spyOn(atom.packages, 'disablePackage').andReturn(true);
      view = new PackageCard({
        name: 'test-package'
      }, this.packageManager);
      expect(view.enablementButton.find('.disable-text').text()).toBe('Disable');
      view.enablementButton.click();
      return expect(atom.packages.disablePackage).toHaveBeenCalled();
    });
    it("can be uninstalled if installed", function() {
      var view;
      setPackageStatusSpies({
        installed: true,
        disabled: false
      });
      view = new PackageCard({
        name: 'test-package'
      }, this.packageManager);
      expect(view.uninstallButton.css('display')).not.toBe('none');
      view.uninstallButton.click();
      return expect(this.packageManager.uninstall).toHaveBeenCalled();
    });
    it("can be installed if currently not installed", function() {
      var view;
      setPackageStatusSpies({
        installed: false,
        disabled: false
      });
      view = new PackageCard({
        name: 'test-package'
      }, this.packageManager);
      expect(view.installButton.css('display')).not.toBe('none');
      expect(view.uninstallButton.css('display')).toBe('none');
      view.installButton.click();
      return expect(this.packageManager.install).toHaveBeenCalled();
    });
    return it("removes the settings button if a package has no settings", function() {
      var view;
      setPackageStatusSpies({
        installed: true,
        disabled: false,
        hasSettings: false
      });
      view = new PackageCard({
        name: 'test-package'
      }, this.packageManager);
      return expect(view.find.settingsButton).not.toExist();
    });
  });

}).call(this);
