(function() {
  var PackageDetailView, PackageManager, path;

  path = require('path');

  PackageDetailView = require('../lib/package-detail-view');

  PackageManager = require('../lib/package-manager');

  describe("PackageDetailView", function() {
    it("displays the grammars registered by the package", function() {
      var settingsPanels;
      settingsPanels = null;
      waitsForPromise(function() {
        return atom.packages.activatePackage(path.join(__dirname, 'fixtures', 'language-test'));
      });
      runs(function() {
        var pack, view;
        pack = atom.packages.getActivePackage('language-test');
        view = new PackageDetailView(pack, new PackageManager());
        return settingsPanels = view.find('.package-grammars .settings-panel');
      });
      waitsFor(function() {
        return settingsPanels.children().length === 2;
      });
      return runs(function() {
        expect(settingsPanels.eq(0).find('.grammar-scope').text()).toBe('Scope: source.a');
        expect(settingsPanels.eq(0).find('.grammar-filetypes').text()).toBe('File Types: .a, .aa, a');
        expect(settingsPanels.eq(1).find('.grammar-scope').text()).toBe('Scope: source.b');
        return expect(settingsPanels.eq(1).find('.grammar-filetypes').text()).toBe('File Types: ');
      });
    });
    it("displays the snippets registered by the package", function() {
      var snippetsTable;
      snippetsTable = null;
      waitsForPromise(function() {
        return atom.packages.activatePackage('snippets');
      });
      waitsForPromise(function() {
        return atom.packages.activatePackage(path.join(__dirname, 'fixtures', 'language-test'));
      });
      runs(function() {
        var pack, view;
        pack = atom.packages.getActivePackage('language-test');
        view = new PackageDetailView(pack, new PackageManager());
        return snippetsTable = view.find('.package-snippets-table tbody');
      });
      waitsFor(function() {
        return snippetsTable.children().length === 2;
      });
      return runs(function() {
        expect(snippetsTable.find('tr:eq(0) td:eq(0)').text()).toBe('b');
        expect(snippetsTable.find('tr:eq(0) td:eq(1)').text()).toBe('BAR');
        expect(snippetsTable.find('tr:eq(0) td:eq(2)').text()).toBe('bar?');
        expect(snippetsTable.find('tr:eq(1) td:eq(0)').text()).toBe('f');
        expect(snippetsTable.find('tr:eq(1) td:eq(1)').text()).toBe('FOO');
        return expect(snippetsTable.find('tr:eq(1) td:eq(2)').text()).toBe('foo!');
      });
    });
    it("does not display keybindings from other platforms", function() {
      var keybindingsTable;
      keybindingsTable = null;
      waitsForPromise(function() {
        return atom.packages.activatePackage(path.join(__dirname, 'fixtures', 'language-test'));
      });
      return runs(function() {
        var pack, view;
        pack = atom.packages.getActivePackage('language-test');
        view = new PackageDetailView(pack, new PackageManager());
        keybindingsTable = view.find('.package-keymap-table tbody');
        return expect(keybindingsTable.children().length).toBe(0);
      });
    });
    describe("when the package is active", function() {
      return it("displays the correct enablement state", function() {
        var packageCard;
        packageCard = null;
        waitsForPromise(function() {
          return atom.packages.activatePackage('status-bar');
        });
        runs(function() {
          var pack, view;
          expect(atom.packages.isPackageActive('status-bar')).toBe(true);
          pack = atom.packages.getLoadedPackage('status-bar');
          view = new PackageDetailView(pack, new PackageManager());
          return packageCard = view.find('.package-card');
        });
        return runs(function() {
          atom.packages.observeDisabledPackages();
          atom.packages.disablePackage('status-bar');
          expect(atom.packages.isPackageDisabled('status-bar')).toBe(true);
          return expect(packageCard.hasClass('disabled')).toBe(true);
        });
      });
    });
    return describe("when the package is not active", function() {
      it("displays the correct enablement state", function() {
        var pack, packageCard, view;
        atom.packages.loadPackage('status-bar');
        expect(atom.packages.isPackageActive('status-bar')).toBe(false);
        pack = atom.packages.getLoadedPackage('status-bar');
        view = new PackageDetailView(pack, new PackageManager());
        packageCard = view.find('.package-card');
        atom.packages.observeDisabledPackages();
        atom.packages.disablePackage('status-bar');
        expect(atom.packages.isPackageDisabled('status-bar')).toBe(true);
        return expect(packageCard.hasClass('disabled')).toBe(true);
      });
      return it("still loads the config schema for the package", function() {
        atom.packages.loadPackage(path.join(__dirname, 'fixtures', 'package-with-config'));
        waitsFor(function() {
          return atom.packages.isPackageLoaded('package-with-config') === true;
        });
        return runs(function() {
          var pack, view;
          expect(atom.config.get('package-with-config.setting')).toBe(void 0);
          pack = atom.packages.getLoadedPackage('package-with-config');
          view = new PackageDetailView(pack, new PackageManager());
          return expect(atom.config.get('package-with-config.setting')).toBe('something');
        });
      });
    });
  });

}).call(this);
