(function() {
  var InstalledPackagesPanel, PackageManager, Q, fs, path;

  path = require('path');

  fs = require('fs-plus');

  InstalledPackagesPanel = require('../lib/installed-packages-panel');

  PackageManager = require('../lib/package-manager');

  Q = require('q');

  describe('InstalledPackagesPanel', function() {
    beforeEach(function() {
      this.packageManager = new PackageManager;
      this.installed = JSON.parse(fs.readFileSync(path.join(__dirname, 'fixtures', 'installed.json')));
      spyOn(this.packageManager, 'getInstalled').andReturn(Q(this.installed));
      return this.panel = new InstalledPackagesPanel(this.packageManager);
    });
    it('shows packages', function() {
      waitsFor(function() {
        return this.packageManager.getInstalled.callCount === 1 && this.panel.communityCount.text().indexOf('…') < 0;
      });
      return runs(function() {
        expect(this.panel.communityCount.text().trim()).toBe('1');
        expect(this.panel.communityPackages.find('.package-card:not(.hidden)').length).toBe(1);
        expect(this.panel.coreCount.text().trim()).toBe('1');
        expect(this.panel.corePackages.find('.package-card:not(.hidden)').length).toBe(1);
        expect(this.panel.devCount.text().trim()).toBe('1');
        return expect(this.panel.devPackages.find('.package-card:not(.hidden)').length).toBe(1);
      });
    });
    return it('filters packages by name', function() {
      waitsFor(function() {
        return this.packageManager.getInstalled.callCount === 1 && this.panel.communityCount.text().indexOf('…') < 0;
      });
      return runs(function() {
        this.panel.filterEditor.getModel().setText('user-');
        window.advanceClock(this.panel.filterEditor.getModel().getBuffer().stoppedChangingDelay);
        expect(this.panel.communityCount.text().trim()).toBe('1/1');
        expect(this.panel.communityPackages.find('.package-card:not(.hidden)').length).toBe(1);
        expect(this.panel.coreCount.text().trim()).toBe('0/1');
        expect(this.panel.corePackages.find('.package-card:not(.hidden)').length).toBe(0);
        expect(this.panel.devCount.text().trim()).toBe('0/1');
        return expect(this.panel.devPackages.find('.package-card:not(.hidden)').length).toBe(0);
      });
    });
  });

}).call(this);
