(function() {
  var KeybindingsPanel, path;

  path = require('path');

  KeybindingsPanel = require('../lib/keybindings-panel');

  describe("KeybindingsPanel", function() {
    var keyBindings, panel, _ref;
    _ref = [], keyBindings = _ref[0], panel = _ref[1];
    beforeEach(function() {
      expect(atom.keymap).toBeDefined();
      keyBindings = [
        {
          source: "" + (atom.getLoadSettings().resourcePath) + path.sep + "keymaps",
          keystrokes: 'ctrl-a',
          command: 'core:select-all',
          selector: '.editor, .platform-test'
        }, {
          source: "" + (atom.getLoadSettings().resourcePath) + path.sep + "keymaps",
          keystrokes: 'ctrl-u',
          command: 'core:undo',
          selector: ".platform-test"
        }, {
          source: "" + (atom.getLoadSettings().resourcePath) + path.sep + "keymaps",
          keystrokes: 'ctrl-u',
          command: 'core:undo',
          selector: ".platform-a, .platform-b"
        }
      ];
      spyOn(atom.keymap, 'getKeyBindings').andReturn(keyBindings);
      return panel = new KeybindingsPanel;
    });
    it("loads and displays core key bindings", function() {
      var row;
      expect(panel.keybindingRows.children().length).toBe(1);
      row = panel.keybindingRows.children(':first');
      expect(row.find('.keystroke').text()).toBe('ctrl-a');
      expect(row.find('.command').text()).toBe('core:select-all');
      expect(row.find('.source').text()).toBe('Core');
      return expect(row.find('.selector').text()).toBe('.editor, .platform-test');
    });
    describe("when a keybinding is copied", function() {
      describe("when the keybinding file ends in .cson", function() {
        return it("writes a CSON snippet to the clipboard", function() {
          spyOn(atom.keymap, 'getUserKeymapPath').andReturn('keymap.cson');
          panel.find('.copy-icon').click();
          return expect(atom.clipboard.read()).toBe("'.editor, .platform-test':\n  'ctrl-a': 'core:select-all'");
        });
      });
      return describe("when the keybinding file ends in .json", function() {
        return it("writes a JSON snippet to the clipboard", function() {
          spyOn(atom.keymap, 'getUserKeymapPath').andReturn('keymap.json');
          panel.find('.copy-icon').click();
          return expect(atom.clipboard.read()).toBe("\".editor, .platform-test\": {\n  \"ctrl-a\": \"core:select-all\"\n}");
        });
      });
    });
    return describe("when the key bindings change", function() {
      return it("reloads the key bindings", function() {
        keyBindings.push({
          source: atom.keymaps.getUserKeymapPath(),
          keystrokes: 'ctrl-b',
          command: 'core:undo',
          selector: '.editor'
        });
        atom.keymaps.emitter.emit('did-reload-keymap');
        waitsFor(function() {
          return panel.keybindingRows.children().length === 2;
        });
        return runs(function() {
          var row;
          row = panel.keybindingRows.children(':last');
          expect(row.find('.keystroke').text()).toBe('ctrl-b');
          expect(row.find('.command').text()).toBe('core:undo');
          expect(row.find('.source').text()).toBe('User');
          return expect(row.find('.selector').text()).toBe('.editor');
        });
      });
    });
  });

}).call(this);
