(function() {
  var $, PackageManager, Q;

  $ = require('atom-space-pen-views').$;

  PackageManager = require('../lib/package-manager');

  Q = require('q');

  describe("package updates status view", function() {
    beforeEach(function() {
      var outdatedPackage;
      outdatedPackage = {
        name: 'out-dated'
      };
      spyOn(PackageManager.prototype, 'getOutdated').andCallFake(function() {
        return Q([outdatedPackage]);
      });
      jasmine.attachToDOM(atom.views.getView(atom.workspace));
      waitsForPromise(function() {
        return atom.packages.activatePackage('status-bar');
      });
      waitsForPromise(function() {
        return atom.packages.activatePackage('settings-view');
      });
      return runs(function() {
        return atom.packages.emitter.emit('did-activate-all');
      });
    });
    return describe("when packages are outdated", function() {
      return it("adds a tile to the status bar", function() {
        return expect($('status-bar .package-updates-status-view').text()).toBe('1');
      });
    });
  });

}).call(this);
