(function() {
  var SettingsPanel, _;

  SettingsPanel = require('../lib/settings-panel');

  _ = require('underscore-plus');

  describe("SettingsPanel", function() {
    var settingsPanel;
    settingsPanel = null;
    return describe("sorted settings", function() {
      beforeEach(function() {
        var config;
        config = {
          type: 'object',
          properties: {
            bar: {
              title: 'Bar',
              description: 'The bar setting',
              type: 'boolean',
              "default": true
            },
            haz: {
              title: 'Haz',
              description: 'The haz setting',
              type: 'string',
              "default": 'haz'
            },
            zing: {
              title: 'Zing',
              description: 'The zing setting',
              type: 'string',
              "default": 'zing',
              order: 1
            },
            zang: {
              title: 'Zang',
              description: 'The baz setting',
              type: 'string',
              "default": 'zang',
              order: 100
            }
          }
        };
        atom.config.setSchema("foo", config);
        atom.config.setDefaults("foo", {
          gong: 'gong'
        });
        expect(_.size(atom.config.get('foo'))).toBe(5);
        return settingsPanel = new SettingsPanel("foo", {
          includeTitle: false
        });
      });
      it("sorts settings by order and then alphabetically by the key", function() {
        var settings, sortedSettings;
        settings = atom.config.get('foo');
        expect(_.size(settings)).toBe(5);
        sortedSettings = settingsPanel.sortSettings("foo", settings);
        expect(sortedSettings[0]).toBe('zing');
        expect(sortedSettings[1]).toBe('zang');
        expect(sortedSettings[2]).toBe('bar');
        expect(sortedSettings[3]).toBe('gong');
        return expect(sortedSettings[4]).toBe('haz');
      });
      return it("gracefully deals with a null settings object", function() {
        var sortedSettings;
        sortedSettings = settingsPanel.sortSettings("foo", null);
        expect(sortedSettings).not.toBeNull;
        return expect(_.size(sortedSettings)).toBe(0);
      });
    });
  });

}).call(this);
