(function() {
  var $$, SettingsView, path;

  path = require('path');

  $$ = require('atom-space-pen-views').$$;

  SettingsView = require('../lib/settings-view');

  describe("SettingsView", function() {
    var settingsView;
    settingsView = null;
    beforeEach(function() {
      settingsView = new SettingsView;
      spyOn(settingsView, "initializePanels").andCallThrough();
      window.advanceClock(10000);
      return waitsFor(function() {
        return settingsView.initializePanels.callCount > 0;
      });
    });
    describe("serialization", function() {
      it("remembers which panel was visible", function() {
        var newSettingsView;
        settingsView.showPanel('Themes');
        newSettingsView = new SettingsView(settingsView.serialize());
        settingsView.remove();
        jasmine.attachToDOM(newSettingsView.element);
        newSettingsView.initializePanels();
        return expect(newSettingsView.activePanelName).toBe('Themes');
      });
      it("shows the previously active panel if it is added after deserialization", function() {
        var newSettingsView;
        settingsView.addCorePanel('Panel 1', 'panel1', function() {
          return $$(function() {
            return this.div({
              id: 'panel-1'
            });
          });
        });
        settingsView.showPanel('Panel 1');
        newSettingsView = new SettingsView(settingsView.serialize());
        newSettingsView.addPanel('Panel 1', 'panel1', function() {
          return $$(function() {
            return this.div({
              id: 'panel-1'
            });
          });
        });
        newSettingsView.initializePanels();
        jasmine.attachToDOM(newSettingsView.element);
        return expect(newSettingsView.activePanelName).toBe('Panel 1');
      });
      it("shows the Settings panel if the last saved active panel name no longer exists", function() {
        var newSettingsView;
        settingsView.addCorePanel('Panel 1', 'panel1', function() {
          return $$(function() {
            return this.div({
              id: 'panel-1'
            });
          });
        });
        settingsView.showPanel('Panel 1');
        newSettingsView = new SettingsView(settingsView.serialize());
        settingsView.remove();
        jasmine.attachToDOM(newSettingsView.element);
        newSettingsView.initializePanels();
        return expect(newSettingsView.activePanelName).toBe('Settings');
      });
      return it("serializes the active panel name even when the panels were never initialized", function() {
        var settingsView2, settingsView3;
        settingsView.showPanel('Themes');
        settingsView2 = new SettingsView(settingsView.serialize());
        settingsView3 = new SettingsView(settingsView2.serialize());
        jasmine.attachToDOM(settingsView3.element);
        settingsView3.initializePanels();
        return expect(settingsView3.activePanelName).toBe('Themes');
      });
    });
    describe(".addCorePanel(name, iconName, view)", function() {
      return it("adds a menu entry to the left and a panel that can be activated by clicking it", function() {
        settingsView.addCorePanel('Panel 1', 'panel1', function() {
          return $$(function() {
            return this.div({
              id: 'panel-1'
            });
          });
        });
        settingsView.addCorePanel('Panel 2', 'panel2', function() {
          return $$(function() {
            return this.div({
              id: 'panel-2'
            });
          });
        });
        expect(settingsView.panelMenu.find('li a:contains(Panel 1)')).toExist();
        expect(settingsView.panelMenu.find('li a:contains(Panel 2)')).toExist();
        expect(settingsView.panelMenu.children(':first')).toHaveClass('active');
        jasmine.attachToDOM(settingsView.element);
        settingsView.panelMenu.find('li a:contains(Panel 1)').click();
        expect(settingsView.panelMenu.children('.active').length).toBe(1);
        expect(settingsView.panelMenu.find('li:contains(Panel 1)')).toHaveClass('active');
        expect(settingsView.panels.find('#panel-1')).toBeVisible();
        expect(settingsView.panels.find('#panel-2')).not.toExist();
        settingsView.panelMenu.find('li a:contains(Panel 2)').click();
        expect(settingsView.panelMenu.children('.active').length).toBe(1);
        expect(settingsView.panelMenu.find('li:contains(Panel 2)')).toHaveClass('active');
        expect(settingsView.panels.find('#panel-1')).toBeHidden();
        return expect(settingsView.panels.find('#panel-2')).toBeVisible();
      });
    });
    return describe("when the package is activated", function() {
      var mainModule;
      mainModule = [][0];
      beforeEach(function() {
        jasmine.attachToDOM(atom.views.getView(atom.workspace));
        return waitsForPromise(function() {
          return atom.packages.activatePackage('settings-view');
        });
      });
      describe("when the settings view is opened with a settings-view:* command", function() {
        var openWithCommand;
        openWithCommand = function(command) {
          atom.commands.dispatch(atom.views.getView(atom.workspace), command);
          return waitsFor(function() {
            return atom.workspace.getActivePaneItem() != null;
          });
        };
        beforeEach(function() {
          return settingsView = null;
        });
        describe("settings-view:open", function() {
          return it("opens the settings view", function() {
            openWithCommand('settings-view:open');
            return runs(function() {
              return expect(atom.workspace.getActivePaneItem().activePanelName).toBe('Settings');
            });
          });
        });
        describe("settings-view:show-keybindings", function() {
          return it("opens the settings view to the keybindings page", function() {
            openWithCommand('settings-view:show-keybindings');
            return runs(function() {
              return expect(atom.workspace.getActivePaneItem().activePanelName).toBe('Keybindings');
            });
          });
        });
        describe("settings-view:change-themes", function() {
          return it("opens the settings view to the themes page", function() {
            openWithCommand('settings-view:change-themes');
            return runs(function() {
              return expect(atom.workspace.getActivePaneItem().activePanelName).toBe('Themes');
            });
          });
        });
        describe("settings-view:uninstall-themes", function() {
          return it("opens the settings view to the themes page", function() {
            openWithCommand('settings-view:uninstall-themes');
            return runs(function() {
              return expect(atom.workspace.getActivePaneItem().activePanelName).toBe('Themes');
            });
          });
        });
        describe("settings-view:uninstall-packages", function() {
          return it("opens the settings view to the install page", function() {
            openWithCommand('settings-view:uninstall-packages');
            return runs(function() {
              return expect(atom.workspace.getActivePaneItem().activePanelName).toBe('Packages');
            });
          });
        });
        describe("settings-view:install-packages-and-themes", function() {
          return it("opens the settings view to the install page", function() {
            openWithCommand('settings-view:install-packages-and-themes');
            return runs(function() {
              return expect(atom.workspace.getActivePaneItem().activePanelName).toBe('Install');
            });
          });
        });
        return describe("settings-view:check-for-package-updates", function() {
          return it("opens the settings view to the install page", function() {
            openWithCommand('settings-view:check-for-package-updates');
            return runs(function() {
              return expect(atom.workspace.getActivePaneItem().activePanelName).toBe('Updates');
            });
          });
        });
      });
      return describe("when atom.workspace.open() is used with a config URI", function() {
        beforeEach(function() {
          return settingsView = null;
        });
        return it("opens the settings to the correct panel with atom://config/<panel-name>", function() {
          waitsForPromise(function() {
            return atom.workspace.open('atom://config').then(function(s) {
              return settingsView = s;
            });
          });
          waits(1);
          runs(function() {
            return expect(settingsView.activePanelName).toBe('Settings');
          });
          waitsForPromise(function() {
            return atom.workspace.open('atom://config/themes').then(function(s) {
              return settingsView = s;
            });
          });
          waits(1);
          runs(function() {
            return expect(settingsView.activePanelName).toBe('Themes');
          });
          waitsForPromise(function() {
            return atom.workspace.open('atom://config/install').then(function(s) {
              return settingsView = s;
            });
          });
          waits(1);
          return runs(function() {
            return expect(settingsView.activePanelName).toBe('Install');
          });
        });
      });
    });
  });

}).call(this);
