(function() {
  var CSON, PackageManager, Q, SettingsView, ThemesPanel, path, _;

  path = require('path');

  _ = require('underscore-plus');

  CSON = require('season');

  Q = require('q');

  PackageManager = require('../lib/package-manager');

  ThemesPanel = require('../lib/themes-panel');

  SettingsView = require('../lib/settings-view');

  describe("ThemesPanel", function() {
    var packageManager, panel, reloadedHandler, settingsView, _ref;
    _ref = [], panel = _ref[0], packageManager = _ref[1], reloadedHandler = _ref[2];
    settingsView = null;
    beforeEach(function() {
      settingsView = new SettingsView;
      atom.packages.loadPackage('atom-light-ui');
      atom.packages.loadPackage('atom-dark-ui');
      atom.packages.loadPackage('atom-light-syntax');
      atom.packages.loadPackage('atom-dark-syntax');
      atom.packages.packageDirPaths.push(path.join(__dirname, 'fixtures'));
      atom.config.set('core.themes', ['atom-dark-ui', 'atom-dark-syntax']);
      reloadedHandler = jasmine.createSpy('reloadedHandler');
      atom.themes.onDidChangeActiveThemes(reloadedHandler);
      atom.themes.activatePackages();
      waitsFor("themes to be reloaded", function() {
        return reloadedHandler.callCount === 1;
      });
      return runs(function() {
        var themeMetadata;
        packageManager = new PackageManager;
        themeMetadata = CSON.readFileSync(path.join(__dirname, 'fixtures', 'a-theme', 'package.json'));
        spyOn(packageManager, 'getFeatured').andCallFake(function(callback) {
          return Q([themeMetadata]);
        });
        panel = new ThemesPanel(packageManager);
        settingsView.addPanel('Themes', null, function() {
          return panel;
        });
        return spyOn(panel, 'scheduleUpdateThemeConfig').andCallFake(function() {
          return this.updateThemeConfig();
        });
      });
    });
    afterEach(function() {
      if (atom.packages.isPackageLoaded('a-theme')) {
        atom.packages.unloadPackage('a-theme');
      }
      return atom.themes.deactivateThemes();
    });
    it("selects the active syntax and UI themes", function() {
      expect(panel.uiMenu.val()).toBe('atom-dark-ui');
      return expect(panel.syntaxMenu.val()).toBe('atom-dark-syntax');
    });
    describe("when a UI theme is selected", function() {
      return it("updates the 'core.themes' config key with the selected UI theme", function() {
        panel.uiMenu.val('atom-light-ui').trigger('change');
        return expect(atom.config.get('core.themes')).toEqual(['atom-light-ui', 'atom-dark-syntax']);
      });
    });
    describe("when a syntax theme is selected", function() {
      return it("updates the 'core.themes' config key with the selected syntax theme", function() {
        panel.syntaxMenu.val('atom-light-syntax').trigger('change');
        return expect(atom.config.get('core.themes')).toEqual(['atom-dark-ui', 'atom-light-syntax']);
      });
    });
    describe("when the 'core.config' key changes", function() {
      return it("refreshes the theme menus", function() {
        reloadedHandler.reset();
        atom.config.set('core.themes', ['atom-light-ui', 'atom-light-syntax']);
        waitsFor(function() {
          return reloadedHandler.callCount === 1;
        });
        return runs(function() {
          expect(panel.uiMenu.val()).toBe('atom-light-ui');
          return expect(panel.syntaxMenu.val()).toBe('atom-light-syntax');
        });
      });
    });
    return xdescribe("when the themes panel is navigated to", function() {
      return xit("focuses the search filter", function() {
        settingsView.showPanel('Themes');
        return expect(panel.filterEditor.hasFocus()).toBe(true);
      });
    });
  });

}).call(this);
