(function() {
  var PackageManager, Q, UpdatesPanel;

  UpdatesPanel = require('../lib/updates-panel');

  PackageManager = require('../lib/package-manager');

  Q = require('q');

  describe('UpdatesPanel', function() {
    beforeEach(function() {
      return this.panel = new UpdatesPanel(new PackageManager);
    });
    it("Shows updates when updates are available", function() {
      var pack;
      pack = {
        name: 'test-package',
        description: 'some description',
        latestVersion: '99.0.0',
        version: '1.0.0'
      };
      this.panel.beforeShow({
        updates: [pack]
      });
      return expect(this.panel.updatesContainer.children().length).toBe(1);
    });
    return it("Shows a message when updates are not available", function() {
      this.panel.beforeShow({
        updates: []
      });
      expect(this.panel.updatesContainer.children().length).toBe(0);
      return expect(this.panel.noUpdatesMessage.css('display')).not.toBe('none');
    });
  });

}).call(this);
