(function() {
  var PEG, allowUnsafeEval, fs, grammarSrc, parser;

  try {
    parser = require('./snippet-body');
  } catch (_error) {
    allowUnsafeEval = require('loophole').allowUnsafeEval;
    fs = require('fs-plus');
    PEG = require('pegjs');
    grammarSrc = fs.readFileSync(require.resolve('./snippet-body.pegjs'), 'utf8');
    parser = null;
    allowUnsafeEval(function() {
      return parser = PEG.buildParser(grammarSrc);
    });
  }

  module.exports = parser;

}).call(this);
