(function() {
  var Range, Snippet, _;

  _ = require('underscore-plus');

  Range = require('atom').Range;

  module.exports = Snippet = (function() {
    function Snippet(_arg) {
      var bodyTree;
      this.name = _arg.name, this.prefix = _arg.prefix, this.bodyText = _arg.bodyText, bodyTree = _arg.bodyTree;
      this.body = this.extractTabStops(bodyTree);
    }

    Snippet.prototype.extractTabStops = function(bodyTree) {
      var bodyText, column, extractTabStops, index, row, tabStopsByIndex, _i, _len, _ref, _ref1;
      tabStopsByIndex = {};
      bodyText = [];
      _ref = [0, 0], row = _ref[0], column = _ref[1];
      extractTabStops = function(bodyTree) {
        var content, index, nextLine, segment, segmentLines, start, _i, _len, _results;
        _results = [];
        for (_i = 0, _len = bodyTree.length; _i < _len; _i++) {
          segment = bodyTree[_i];
          if (segment.index != null) {
            index = segment.index, content = segment.content;
            if (index === 0) {
              index = Infinity;
            }
            start = [row, column];
            extractTabStops(content);
            if (tabStopsByIndex[index] == null) {
              tabStopsByIndex[index] = [];
            }
            _results.push(tabStopsByIndex[index].push(new Range(start, [row, column])));
          } else if (_.isString(segment)) {
            bodyText.push(segment);
            segmentLines = segment.split('\n');
            column += segmentLines.shift().length;
            _results.push((function() {
              var _results1;
              _results1 = [];
              while ((nextLine = segmentLines.shift()) != null) {
                row += 1;
                _results1.push(column = nextLine.length);
              }
              return _results1;
            })());
          } else {
            _results.push(void 0);
          }
        }
        return _results;
      };
      extractTabStops(bodyTree);
      this.lineCount = row + 1;
      this.tabStops = [];
      _ref1 = _.keys(tabStopsByIndex).sort((function(arg1, arg2) {
        return arg1 - arg2;
      }));
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        index = _ref1[_i];
        this.tabStops.push(tabStopsByIndex[index]);
      }
      return bodyText.join('');
    };

    return Snippet;

  })();

}).call(this);
