(function() {
  var $$, SelectListView, SnippetsAvailable, _, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ = require('underscore-plus');

  _ref = require('atom-space-pen-views'), $$ = _ref.$$, SelectListView = _ref.SelectListView;

  module.exports = SnippetsAvailable = (function(_super) {
    __extends(SnippetsAvailable, _super);

    function SnippetsAvailable() {
      return SnippetsAvailable.__super__.constructor.apply(this, arguments);
    }

    SnippetsAvailable.prototype.panel = null;

    SnippetsAvailable.prototype.initialize = function(snippets) {
      this.snippets = snippets;
      SnippetsAvailable.__super__.initialize.apply(this, arguments);
      return this.addClass('available-snippets');
    };

    SnippetsAvailable.prototype.getFilterKey = function() {
      return 'searchText';
    };

    SnippetsAvailable.prototype.toggle = function(editor) {
      this.editor = editor;
      if (this.panel != null) {
        return this.cancel();
      } else {
        this.populate();
        return this.attach();
      }
    };

    SnippetsAvailable.prototype.cancelled = function() {
      this.editor = null;
      if (this.panel != null) {
        this.panel.destroy();
        return this.panel = null;
      }
    };

    SnippetsAvailable.prototype.populate = function() {
      var snippet, snippets, _i, _len;
      snippets = _.values(this.snippets.getSnippets(this.editor));
      for (_i = 0, _len = snippets.length; _i < _len; _i++) {
        snippet = snippets[_i];
        snippet.searchText = _.compact([snippet.prefix, snippet.name]).join(' ');
      }
      return this.setItems(snippets);
    };

    SnippetsAvailable.prototype.attach = function() {
      this.storeFocusedElement();
      this.panel = atom.workspace.addModalPanel({
        item: this
      });
      return this.focusFilterEditor();
    };

    SnippetsAvailable.prototype.viewForItem = function(snippet) {
      return $$(function() {
        return this.li({
          "class": 'two-lines'
        }, (function(_this) {
          return function() {
            _this.div({
              "class": 'primary-line'
            }, snippet.prefix);
            return _this.div({
              "class": 'secondary-line'
            }, snippet.name);
          };
        })(this));
      });
    };

    SnippetsAvailable.prototype.confirmed = function(snippet) {
      var cursor, editor, _i, _len, _ref1, _results;
      editor = this.editor;
      this.cancel();
      _ref1 = editor.getCursors();
      _results = [];
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        cursor = _ref1[_i];
        _results.push(this.snippets.insert(snippet.bodyText, editor, cursor));
      }
      return _results;
    };

    return SnippetsAvailable;

  })(SelectListView);

}).call(this);
