(function() {
  var CorrectionsView, Range, SelectListView,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  Range = require('atom').Range;

  SelectListView = require('atom-space-pen-views').SelectListView;

  module.exports = CorrectionsView = (function(_super) {
    __extends(CorrectionsView, _super);

    function CorrectionsView() {
      return CorrectionsView.__super__.constructor.apply(this, arguments);
    }

    CorrectionsView.prototype.initialize = function(editor, corrections, marker) {
      this.editor = editor;
      this.corrections = corrections;
      this.marker = marker;
      CorrectionsView.__super__.initialize.apply(this, arguments);
      this.addClass('corrections popover-list');
      return this.attach();
    };

    CorrectionsView.prototype.attach = function() {
      this.setItems(this.corrections);
      return this.overlayDecoration = this.editor.decorateMarker(this.marker, {
        type: 'overlay',
        item: this
      });
    };

    CorrectionsView.prototype.attached = function() {
      this.storeFocusedElement();
      return this.focusFilterEditor();
    };

    CorrectionsView.prototype.destroy = function() {
      this.cancel();
      return this.remove();
    };

    CorrectionsView.prototype.confirmed = function(correction) {
      this.cancel();
      if (!correction) {
        return;
      }
      return this.editor.transact((function(_this) {
        return function() {
          _this.editor.selectMarker(_this.marker);
          return _this.editor.insertText(correction);
        };
      })(this));
    };

    CorrectionsView.prototype.cancelled = function() {
      this.overlayDecoration.destroy();
      return this.restoreFocus();
    };

    CorrectionsView.prototype.viewForItem = function(word) {
      var element;
      element = document.createElement('li');
      element.textContent = word;
      return element;
    };

    CorrectionsView.prototype.selectNextItemView = function() {
      CorrectionsView.__super__.selectNextItemView.apply(this, arguments);
      return false;
    };

    CorrectionsView.prototype.selectPreviousItemView = function() {
      CorrectionsView.__super__.selectPreviousItemView.apply(this, arguments);
      return false;
    };

    CorrectionsView.prototype.getEmptyMessage = function(itemCount) {
      if (itemCount === 0) {
        return 'No corrections';
      } else {
        return CorrectionsView.__super__.getEmptyMessage.apply(this, arguments);
      }
    };

    return CorrectionsView;

  })(SelectListView);

}).call(this);
