(function() {
  var SpellCheckView, addViewToEditor;

  SpellCheckView = null;

  module.exports = {
    config: {
      grammars: {
        type: 'array',
        "default": ['source.asciidoc', 'source.gfm', 'text.git-commit', 'text.plain', 'text.plain.null-grammar']
      }
    },
    activate: function() {
      return this.disposable = atom.workspace.observeTextEditors(addViewToEditor);
    },
    deactivate: function() {
      return this.disposable.dispose();
    }
  };

  addViewToEditor = function(editor) {
    if (SpellCheckView == null) {
      SpellCheckView = require('./spell-check-view');
    }
    return new SpellCheckView(editor);
  };

}).call(this);
