(function() {
  var CorrectionsView, MisspellingView;

  CorrectionsView = require('./corrections-view');

  module.exports = MisspellingView = (function() {
    function MisspellingView(bufferRange, editor) {
      this.editor = editor;
      this.createMarker(bufferRange);
      this.correctMispellingCommand = atom.commands.add(atom.views.getView(this.editor), 'spell-check:correct-misspelling', (function(_this) {
        return function() {
          var _ref;
          if (_this.containsCursor()) {
            if ((_ref = _this.correctionsView) != null) {
              _ref.destroy();
            }
            return _this.correctionsView = new CorrectionsView(_this.editor, _this.getCorrections(), _this.marker);
          }
        };
      })(this));
    }

    MisspellingView.prototype.createMarker = function(bufferRange) {
      this.marker = this.editor.markBufferRange(bufferRange, {
        invalidate: 'touch',
        replicate: false,
        persistent: false
      });
      return this.editor.decorateMarker(this.marker, {
        type: 'highlight',
        "class": 'spell-check-misspelling',
        deprecatedRegionClass: 'misspelling'
      });
    };

    MisspellingView.prototype.getCorrections = function() {
      var SpellChecker, corrections, misspelling, screenRange;
      screenRange = this.marker.getScreenRange();
      misspelling = this.editor.getTextInRange(this.editor.bufferRangeForScreenRange(screenRange));
      SpellChecker = require('spellchecker');
      return corrections = SpellChecker.getCorrectionsForMisspelling(misspelling);
    };

    MisspellingView.prototype.containsCursor = function() {
      var cursor;
      cursor = this.editor.getCursorScreenPosition();
      return this.marker.getScreenRange().containsPoint(cursor, false);
    };

    MisspellingView.prototype.destroy = function() {
      var _ref, _ref1, _ref2;
      if ((_ref = this.correctMispellingCommand) != null) {
        _ref.dispose();
      }
      this.correctMispellingCommand = null;
      if ((_ref1 = this.correctionsView) != null) {
        _ref1.remove();
      }
      this.correctionsView = null;
      if ((_ref2 = this.marker) != null) {
        _ref2.destroy();
      }
      return this.marker = null;
    };

    return MisspellingView;

  })();

}).call(this);
