(function() {
  var SpellChecker, wordRegex;

  SpellChecker = require('spellchecker');

  wordRegex = /(?:^|[\s\[\]"'])([a-zA-Z]+([a-zA-Z']+[a-zA-Z])?)(?=[\s\.\[\]:,"']|$)/g;

  module.exports = function(text) {
    var endColumn, line, matches, misspellings, row, startColumn, word, _i, _len, _ref;
    row = 0;
    misspellings = [];
    _ref = text.split('\n');
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      line = _ref[_i];
      while (matches = wordRegex.exec(line)) {
        word = matches[1];
        if (word === 'GitHub' || word === 'github') {
          continue;
        }
        if (!SpellChecker.isMisspelled(word)) {
          continue;
        }
        startColumn = matches.index + matches[0].length - word.length;
        endColumn = startColumn + word.length;
        misspellings.push([[row, startColumn], [row, endColumn]]);
      }
      row++;
    }
    return misspellings;
  };

}).call(this);
