(function() {
  var CompositeDisposable, MisspellingView, SpellCheckTask, SpellCheckView, _;

  _ = require('underscore-plus');

  CompositeDisposable = require('atom').CompositeDisposable;

  MisspellingView = require('./misspelling-view');

  SpellCheckTask = require('./spell-check-task');

  module.exports = SpellCheckView = (function() {
    SpellCheckView.content = function() {
      return this.div({
        "class": 'spell-check'
      });
    };

    function SpellCheckView(editor) {
      this.editor = editor;
      this.disposables = new CompositeDisposable;
      this.views = [];
      this.task = new SpellCheckTask();
      this.disposables.add(this.editor.onDidChangePath((function(_this) {
        return function() {
          return _this.subscribeToBuffer();
        };
      })(this)));
      this.disposables.add(this.editor.onDidChangeGrammar((function(_this) {
        return function() {
          return _this.subscribeToBuffer();
        };
      })(this)));
      this.disposables.add(atom.config.onDidChange('editor.fontSize', (function(_this) {
        return function() {
          return _this.subscribeToBuffer();
        };
      })(this)));
      this.disposables.add(atom.config.onDidChange('spell-check.grammars', (function(_this) {
        return function() {
          return _this.subscribeToBuffer();
        };
      })(this)));
      this.subscribeToBuffer();
      this.disposables.add(this.editor.onDidDestroy(this.destroy.bind(this)));
    }

    SpellCheckView.prototype.destroy = function() {
      this.unsubscribeFromBuffer();
      this.disposables.dispose();
      return this.task.terminate();
    };

    SpellCheckView.prototype.unsubscribeFromBuffer = function() {
      this.destroyViews();
      if (this.buffer != null) {
        this.bufferDisposable.dispose();
        return this.buffer = null;
      }
    };

    SpellCheckView.prototype.subscribeToBuffer = function() {
      this.unsubscribeFromBuffer();
      if (this.spellCheckCurrentGrammar()) {
        this.buffer = this.editor.getBuffer();
        this.bufferDisposable = this.buffer.onDidStopChanging((function(_this) {
          return function() {
            return _this.updateMisspellings();
          };
        })(this));
        return this.updateMisspellings();
      }
    };

    SpellCheckView.prototype.spellCheckCurrentGrammar = function() {
      var grammar;
      grammar = this.editor.getGrammar().scopeName;
      return _.contains(atom.config.get('spell-check.grammars'), grammar);
    };

    SpellCheckView.prototype.destroyViews = function() {
      var view, _results;
      _results = [];
      while (view = this.views.shift()) {
        _results.push(view.destroy());
      }
      return _results;
    };

    SpellCheckView.prototype.addViews = function(misspellings) {
      var misspelling, view, _i, _len, _results;
      _results = [];
      for (_i = 0, _len = misspellings.length; _i < _len; _i++) {
        misspelling = misspellings[_i];
        view = new MisspellingView(misspelling, this.editor);
        _results.push(this.views.push(view));
      }
      return _results;
    };

    SpellCheckView.prototype.updateMisspellings = function() {
      var error, _ref;
      try {
        return this.task.start(this.buffer.getText(), (function(_this) {
          return function(misspellings) {
            _this.destroyViews();
            if (_this.buffer != null) {
              return _this.addViews(misspellings);
            }
          };
        })(this));
      } catch (_error) {
        error = _error;
        return console.warn('Error starting spell check task', (_ref = error.stack) != null ? _ref : error);
      }
    };

    return SpellCheckView;

  })();

}).call(this);
