(function() {
  describe("Spell check", function() {
    var editor, editorElement, workspaceElement, _ref;
    _ref = [], workspaceElement = _ref[0], editor = _ref[1], editorElement = _ref[2];
    beforeEach(function() {
      workspaceElement = atom.views.getView(atom.workspace);
      waitsForPromise(function() {
        return atom.packages.activatePackage('language-text');
      });
      waitsForPromise(function() {
        return atom.packages.activatePackage('language-javascript');
      });
      runs(function() {
        return atom.config.set('spell-check.grammars', []);
      });
      waitsForPromise(function() {
        return atom.workspace.open('sample.js');
      });
      waitsForPromise(function() {
        return atom.packages.activatePackage('spell-check');
      });
      return runs(function() {
        jasmine.attachToDOM(workspaceElement);
        editor = atom.workspace.getActiveTextEditor();
        return editorElement = atom.views.getView(editor);
      });
    });
    it("decorates all misspelled words", function() {
      var decorations;
      editor.setText("This middle of thiss sentencts has issues and the \"edn\" 'dsoe' too");
      atom.config.set('spell-check.grammars', ['source.js']);
      decorations = null;
      waitsFor(function() {
        decorations = editor.getHighlightDecorations({
          "class": 'spell-check-misspelling'
        });
        return decorations.length > 0;
      });
      return runs(function() {
        expect(decorations.length).toBe(4);
        expect(decorations[0].marker.getBufferRange()).toEqual([[0, 15], [0, 20]]);
        expect(decorations[1].marker.getBufferRange()).toEqual([[0, 21], [0, 30]]);
        expect(decorations[2].marker.getBufferRange()).toEqual([[0, 51], [0, 54]]);
        return expect(decorations[3].marker.getBufferRange()).toEqual([[0, 57], [0, 61]]);
      });
    });
    it("hides decorations when a misspelled word is edited", function() {
      var decorations;
      editor.setText('notaword');
      advanceClock(editor.getBuffer().getStoppedChangingDelay());
      atom.config.set('spell-check.grammars', ['source.js']);
      decorations = null;
      waitsFor(function() {
        decorations = editor.getHighlightDecorations({
          "class": 'spell-check-misspelling'
        });
        return decorations.length > 0;
      });
      return runs(function() {
        expect(decorations.length).toBe(1);
        editor.moveToEndOfLine();
        editor.insertText('a');
        advanceClock(editor.getBuffer().getStoppedChangingDelay());
        decorations = editor.getHighlightDecorations({
          "class": 'spell-check-misspelling'
        });
        expect(decorations.length).toBe(1);
        return expect(decorations[0].marker.isValid()).toBe(false);
      });
    });
    describe("when spell checking for a grammar is removed", function() {
      return it("removes all the misspellings", function() {
        var decorations;
        editor.setText('notaword');
        advanceClock(editor.getBuffer().getStoppedChangingDelay());
        atom.config.set('spell-check.grammars', ['source.js']);
        decorations = null;
        waitsFor(function() {
          return editor.getHighlightDecorations({
            "class": 'spell-check-misspelling'
          }).length > 0;
        });
        return runs(function() {
          expect(editor.getHighlightDecorations({
            "class": 'spell-check-misspelling'
          }).length).toBe(1);
          atom.config.set('spell-check.grammars', []);
          return expect(editor.getHighlightDecorations({
            "class": 'spell-check-misspelling'
          }).length).toBe(0);
        });
      });
    });
    describe("when the editor's grammar changes to one that does not have spell check enabled", function() {
      return it("removes all the misspellings", function() {
        editor.setText('notaword');
        advanceClock(editor.getBuffer().getStoppedChangingDelay());
        atom.config.set('spell-check.grammars', ['source.js']);
        waitsFor(function() {
          return editor.getHighlightDecorations({
            "class": 'spell-check-misspelling'
          }).length > 0;
        });
        return runs(function() {
          expect(editor.getHighlightDecorations({
            "class": 'spell-check-misspelling'
          }).length).toBe(1);
          editor.setGrammar(atom.grammars.selectGrammar('.txt'));
          return expect(editor.getHighlightDecorations({
            "class": 'spell-check-misspelling'
          }).length).toBe(0);
        });
      });
    });
    describe("when 'spell-check:correct-misspelling' is triggered on the editor", function() {
      describe("when the cursor touches a misspelling that has corrections", function() {
        return it("displays the corrections for the misspelling and replaces the misspelling when a correction is selected", function() {
          editor.setText('tofether');
          advanceClock(editor.getBuffer().getStoppedChangingDelay());
          atom.config.set('spell-check.grammars', ['source.js']);
          waitsFor(function() {
            return editor.getHighlightDecorations({
              "class": 'spell-check-misspelling'
            }).length > 0;
          });
          return runs(function() {
            var correctionsElement;
            atom.commands.dispatch(editorElement, 'spell-check:correct-misspelling');
            correctionsElement = editorElement.querySelector('.corrections');
            expect(correctionsElement).toBeDefined();
            expect(correctionsElement.querySelectorAll('li').length).toBeGreaterThan(0);
            expect(correctionsElement.querySelectorAll('li')[0].textContent).toBe("together");
            atom.commands.dispatch(correctionsElement, 'core:confirm');
            expect(editor.getText()).toBe('together');
            expect(editor.getCursorBufferPosition()).toEqual([0, 8]);
            advanceClock(editor.getBuffer().getStoppedChangingDelay());
            expect(editorElement.querySelectorAll('.spell-check-misspelling').length).toBe(0);
            return expect(editorElement.querySelector('.corrections')).toBeNull();
          });
        });
      });
      return describe("when the cursor touches a misspelling that has no corrections", function() {
        return it("displays a message saying no corrections found", function() {
          editor.setText('zxcasdfysyadfyasdyfasdfyasdfyasdfyasydfasdf');
          advanceClock(editor.getBuffer().getStoppedChangingDelay());
          atom.config.set('spell-check.grammars', ['source.js']);
          waitsFor(function() {
            return editor.getHighlightDecorations({
              "class": 'spell-check-misspelling'
            }).length > 0;
          });
          return runs(function() {
            atom.commands.dispatch(editorElement, 'spell-check:correct-misspelling');
            expect(editorElement.querySelectorAll('.corrections').length).toBe(1);
            expect(editorElement.querySelectorAll('.corrections li').length).toBe(0);
            return expect(editorElement.querySelector('.corrections').textContent).toBe("No corrections");
          });
        });
      });
    });
    return describe("when the editor is destroyed", function() {
      return it("destroys all misspelling markers", function() {
        editor.setText('mispelling');
        atom.config.set('spell-check.grammars', ['source.js']);
        waitsFor(function() {
          return editor.getHighlightDecorations({
            "class": 'spell-check-misspelling'
          }).length > 0;
        });
        return runs(function() {
          editor.destroy();
          return expect(editor.getMarkers().length).toBe(0);
        });
      });
    });
  });

}).call(this);
