(function() {
  var CursorPositionView,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  CursorPositionView = (function(_super) {
    __extends(CursorPositionView, _super);

    function CursorPositionView() {
      return CursorPositionView.__super__.constructor.apply(this, arguments);
    }

    CursorPositionView.prototype.initialize = function() {
      this.classList.add('cursor-position', 'inline-block');
      this.activeItemSubscription = atom.workspace.onDidChangeActivePaneItem((function(_this) {
        return function(activeItem) {
          return _this.subscribeToActiveTextEditor();
        };
      })(this));
      return this.subscribeToActiveTextEditor();
    };

    CursorPositionView.prototype.destroy = function() {
      var _ref;
      this.activeItemSubscription.dispose();
      return (_ref = this.cursorSubscription) != null ? _ref.dispose() : void 0;
    };

    CursorPositionView.prototype.subscribeToActiveTextEditor = function() {
      var _ref, _ref1;
      if ((_ref = this.cursorSubscription) != null) {
        _ref.dispose();
      }
      this.cursorSubscription = (_ref1 = this.getActiveTextEditor()) != null ? _ref1.onDidChangeCursorPosition((function(_this) {
        return function() {
          return _this.updatePosition();
        };
      })(this)) : void 0;
      return this.updatePosition();
    };

    CursorPositionView.prototype.getActiveTextEditor = function() {
      return atom.workspace.getActiveTextEditor();
    };

    CursorPositionView.prototype.updatePosition = function() {
      var position, _ref;
      if (position = (_ref = this.getActiveTextEditor()) != null ? _ref.getCursorBufferPosition() : void 0) {
        return this.textContent = "" + (position.row + 1) + "," + (position.column + 1);
      } else {
        return this.textContent = '';
      }
    };

    return CursorPositionView;

  })(HTMLElement);

  module.exports = document.registerElement('status-bar-cursor', {
    prototype: CursorPositionView.prototype,
    "extends": 'div'
  });

}).call(this);
