(function() {
  var FileInfoView,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  FileInfoView = (function(_super) {
    __extends(FileInfoView, _super);

    function FileInfoView() {
      return FileInfoView.__super__.constructor.apply(this, arguments);
    }

    FileInfoView.prototype.initialize = function() {
      this.classList.add('file-info', 'inline-block');
      this.currentPath = document.createElement('span');
      this.currentPath.classList.add('current-path');
      this.appendChild(this.currentPath);
      this.bufferModified = document.createElement('span');
      this.bufferModified.classList.add('buffer-modified');
      this.appendChild(this.bufferModified);
      this.activeItemSubscription = atom.workspace.onDidChangeActivePaneItem((function(_this) {
        return function() {
          return _this.subscribeToActiveItem();
        };
      })(this));
      return this.subscribeToActiveItem();
    };

    FileInfoView.prototype.subscribeToActiveItem = function() {
      var activeItem, _ref, _ref1;
      if ((_ref = this.modifiedSubscription) != null) {
        _ref.dispose();
      }
      if ((_ref1 = this.titleSubscription) != null) {
        _ref1.dispose();
      }
      if (activeItem = this.getActiveItem()) {
        if (this.updateCallback == null) {
          this.updateCallback = (function(_this) {
            return function() {
              return _this.update();
            };
          })(this);
        }
        if (typeof activeItem.onDidChangeTitle === 'function') {
          this.titleSubscription = activeItem.onDidChangeTitle(this.updateCallback);
        } else if (typeof activeItem.on === 'function') {
          activeItem.on('title-changed', this.updateCallback);
          this.titleSubscription = {
            dispose: (function(_this) {
              return function() {
                return typeof activeItem.off === "function" ? activeItem.off('title-changed', _this.updateCallback) : void 0;
              };
            })(this)
          };
        }
        this.modifiedSubscription = typeof activeItem.onDidChangeModified === "function" ? activeItem.onDidChangeModified(this.updateCallback) : void 0;
      }
      return this.update();
    };

    FileInfoView.prototype.destroy = function() {
      var _ref, _ref1;
      this.activeItemSubscription.dispose();
      if ((_ref = this.titleSubscription) != null) {
        _ref.dispose();
      }
      return (_ref1 = this.modifiedSubscription) != null ? _ref1.dispose() : void 0;
    };

    FileInfoView.prototype.getActiveItem = function() {
      return atom.workspace.getActivePaneItem();
    };

    FileInfoView.prototype.update = function() {
      var _ref;
      this.updatePathText();
      return this.updateBufferHasModifiedText((_ref = this.getActiveItem()) != null ? typeof _ref.isModified === "function" ? _ref.isModified() : void 0 : void 0);
    };

    FileInfoView.prototype.updateBufferHasModifiedText = function(isModified) {
      if (isModified) {
        if (!this.isModified) {
          this.bufferModified.textContent = '*';
        }
        return this.isModified = true;
      } else {
        if (this.isModified) {
          this.bufferModified.textContent = '';
        }
        return this.isModified = false;
      }
    };

    FileInfoView.prototype.updatePathText = function() {
      var path, title, _ref, _ref1;
      if (path = (_ref = this.getActiveItem()) != null ? typeof _ref.getPath === "function" ? _ref.getPath() : void 0 : void 0) {
        return this.currentPath.textContent = atom.project.relativize(path);
      } else if (title = (_ref1 = this.getActiveItem()) != null ? typeof _ref1.getTitle === "function" ? _ref1.getTitle() : void 0 : void 0) {
        return this.currentPath.textContent = title;
      } else {
        return this.currentPath.textContent = '';
      }
    };

    return FileInfoView;

  })(HTMLElement);

  module.exports = document.registerElement('status-bar-file', {
    prototype: FileInfoView.prototype,
    "extends": 'div'
  });

}).call(this);
