(function() {
  var CompositeDisposable, GitView,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  CompositeDisposable = require("atom").CompositeDisposable;

  GitView = (function(_super) {
    __extends(GitView, _super);

    function GitView() {
      return GitView.__super__.constructor.apply(this, arguments);
    }

    GitView.prototype.initialize = function() {
      this.classList.add('git-view');
      this.createBranchArea();
      this.createCommitsArea();
      this.createStatusArea();
      this.activeItemSubscription = atom.workspace.onDidChangeActivePaneItem((function(_this) {
        return function() {
          return _this.subscribeToActiveItem();
        };
      })(this));
      this.projectPathSubscription = atom.project.onDidChangePaths((function(_this) {
        return function() {
          return _this.subscribeToRepositories();
        };
      })(this));
      this.subscribeToRepositories();
      return this.subscribeToActiveItem();
    };

    GitView.prototype.createBranchArea = function() {
      var branchIcon;
      this.branchArea = document.createElement('div');
      this.branchArea.classList.add('git-branch', 'inline-block');
      this.appendChild(this.branchArea);
      branchIcon = document.createElement('span');
      branchIcon.classList.add('icon', 'icon-git-branch');
      this.branchArea.appendChild(branchIcon);
      this.branchLabel = document.createElement('span');
      this.branchLabel.classList.add('branch-label');
      return this.branchArea.appendChild(this.branchLabel);
    };

    GitView.prototype.createCommitsArea = function() {
      this.commitsArea = document.createElement('div');
      this.commitsArea.classList.add('git-commits', 'inline-block');
      this.appendChild(this.commitsArea);
      this.commitsAhead = document.createElement('span');
      this.commitsAhead.classList.add('icon', 'icon-arrow-up', 'commits-ahead-label');
      this.commitsArea.appendChild(this.commitsAhead);
      this.commitsBehind = document.createElement('span');
      this.commitsBehind.classList.add('icon', 'icon-arrow-down', 'commits-behind-label');
      return this.commitsArea.appendChild(this.commitsBehind);
    };

    GitView.prototype.createStatusArea = function() {
      this.gitStatus = document.createElement('div');
      this.gitStatus.classList.add('git-status', 'inline-block');
      this.appendChild(this.gitStatus);
      this.gitStatusIcon = document.createElement('span');
      this.gitStatusIcon.classList.add('icon');
      return this.gitStatus.appendChild(this.gitStatusIcon);
    };

    GitView.prototype.subscribeToActiveItem = function() {
      var activeItem, _ref;
      activeItem = this.getActiveItem();
      if ((_ref = this.savedSubscription) != null) {
        _ref.dispose();
      }
      this.savedSubscription = activeItem != null ? typeof activeItem.onDidSave === "function" ? activeItem.onDidSave((function(_this) {
        return function() {
          return _this.update();
        };
      })(this)) : void 0 : void 0;
      return this.update();
    };

    GitView.prototype.subscribeToRepositories = function() {
      var repo, _i, _len, _ref, _ref1, _results;
      if ((_ref = this.repositorySubscriptions) != null) {
        _ref.dispose();
      }
      this.repositorySubscriptions = new CompositeDisposable;
      _ref1 = atom.project.getRepositories();
      _results = [];
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        repo = _ref1[_i];
        if (!(repo != null)) {
          continue;
        }
        this.repositorySubscriptions.add(repo.onDidChangeStatus((function(_this) {
          return function(_arg) {
            var path, status;
            path = _arg.path, status = _arg.status;
            if (path === _this.getActiveItemPath()) {
              return _this.update();
            }
          };
        })(this)));
        _results.push(this.repositorySubscriptions.add(repo.onDidChangeStatuses((function(_this) {
          return function() {
            return _this.update();
          };
        })(this))));
      }
      return _results;
    };

    GitView.prototype.destroy = function() {
      var _ref, _ref1, _ref2, _ref3;
      if ((_ref = this.activeItemSubscription) != null) {
        _ref.dispose();
      }
      if ((_ref1 = this.projectPathSubscription) != null) {
        _ref1.dispose();
      }
      if ((_ref2 = this.savedSubscription) != null) {
        _ref2.dispose();
      }
      return (_ref3 = this.repositorySubscriptions) != null ? _ref3.dispose() : void 0;
    };

    GitView.prototype.getActiveItemPath = function() {
      var _ref;
      return (_ref = this.getActiveItem()) != null ? typeof _ref.getPath === "function" ? _ref.getPath() : void 0 : void 0;
    };

    GitView.prototype.getRepositoryForActiveItem = function() {
      var repo, rootDir, rootDirIndex, _i, _len, _ref;
      rootDir = atom.project.relativizePath(this.getActiveItemPath())[0];
      rootDirIndex = atom.project.getPaths().indexOf(rootDir);
      if (rootDirIndex >= 0) {
        return atom.project.getRepositories()[rootDirIndex];
      } else {
        _ref = atom.project.getRepositories();
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          repo = _ref[_i];
          if (repo) {
            return repo;
          }
        }
      }
    };

    GitView.prototype.getActiveItem = function() {
      return atom.workspace.getActivePaneItem();
    };

    GitView.prototype.update = function() {
      var repo;
      repo = this.getRepositoryForActiveItem();
      this.updateBranchText(repo);
      this.updateAheadBehindCount(repo);
      return this.updateStatusText(repo);
    };

    GitView.prototype.updateBranchText = function(repo) {
      var head;
      this.branchArea.style.display = 'none';
      if (this.showBranchInformation()) {
        head = (repo != null ? repo.getShortHead(this.getActiveItemPath()) : void 0) || '';
        this.branchLabel.textContent = head;
        if (head) {
          return this.branchArea.style.display = '';
        }
      }
    };

    GitView.prototype.showBranchInformation = function() {
      var itemPath;
      if (itemPath = this.getActiveItemPath()) {
        return atom.project.contains(itemPath);
      } else {
        return this.getActiveItem() == null;
      }
    };

    GitView.prototype.updateAheadBehindCount = function(repo) {
      var ahead, behind, itemPath, _ref, _ref1;
      itemPath = this.getActiveItemPath();
      if ((repo != null) && this.showBranchInformation()) {
        _ref1 = (_ref = repo.getCachedUpstreamAheadBehindCount(itemPath)) != null ? _ref : {}, ahead = _ref1.ahead, behind = _ref1.behind;
        if (ahead > 0) {
          this.commitsAhead.textContent = ahead;
          this.commitsAhead.style.display = '';
        } else {
          this.commitsAhead.style.display = 'none';
        }
        if (behind > 0) {
          this.commitsBehind.textContent = behind;
          this.commitsBehind.style.display = '';
        } else {
          this.commitsBehind.style.display = 'none';
        }
      }
      if (ahead > 0 || behind > 0) {
        return this.commitsArea.style.display = '';
      } else {
        return this.commitsArea.style.display = 'none';
      }
    };

    GitView.prototype.updateStatusText = function(repo) {
      var itemPath, stats, status, textEditor, _ref;
      itemPath = this.getActiveItemPath();
      status = (_ref = repo != null ? repo.getCachedPathStatus(itemPath) : void 0) != null ? _ref : 0;
      this.gitStatusIcon.classList.remove('icon-diff-modified', 'status-modified', 'icon-diff-added', 'status-added', 'icon-diff-ignored', 'status-ignored');
      if (repo != null ? repo.isStatusModified(status) : void 0) {
        this.gitStatusIcon.classList.add('icon-diff-modified', 'status-modified');
        stats = repo.getDiffStats(itemPath);
        if (stats.added && stats.deleted) {
          this.gitStatusIcon.textContent = "+" + stats.added + ", -" + stats.deleted;
        } else if (stats.added) {
          this.gitStatusIcon.textContent = "+" + stats.added;
        } else if (stats.deleted) {
          this.gitStatusIcon.textContent = "-" + stats.deleted;
        } else {
          this.gitStatusIcon.textContent = '';
        }
        return this.gitStatus.style.display = '';
      } else if (repo != null ? repo.isStatusNew(status) : void 0) {
        this.gitStatusIcon.classList.add('icon-diff-added', 'status-added');
        if (textEditor = atom.workspace.getActiveTextEditor()) {
          this.gitStatusIcon.textContent = "+" + (textEditor.getLineCount());
        } else {
          this.gitStatusIcon.textContent = '';
        }
        return this.gitStatus.style.display = '';
      } else if (repo != null ? repo.isPathIgnored(itemPath) : void 0) {
        this.gitStatusIcon.classList.add('icon-diff-ignored', 'status-ignored');
        this.gitStatusIcon.textContent = '';
        return this.gitStatus.style.display = '';
      } else {
        return this.gitStatus.style.display = 'none';
      }
    };

    return GitView;

  })(HTMLElement);

  module.exports = document.registerElement('status-bar-git', {
    prototype: GitView.prototype,
    "extends": 'div'
  });

}).call(this);
