(function() {
  var CursorPositionView, FileInfoView, GitView, Grim, SelectionCountView, StatusBarView,
    __slice = [].slice;

  Grim = require('grim');

  StatusBarView = require('./status-bar-view');

  FileInfoView = require('./file-info-view');

  CursorPositionView = require('./cursor-position-view');

  SelectionCountView = require('./selection-count-view');

  GitView = require('./git-view');

  module.exports = {
    activate: function() {
      var $, LaunchModeView, devMode, launchModeView, safeMode, wrappedStatusBar, _ref;
      this.statusBar = new StatusBarView();
      this.statusBar.initialize();
      this.statusBarPanel = atom.workspace.addBottomPanel({
        item: this.statusBar,
        priority: 0
      });
      if (Grim.includeDeprecatedAPIs) {
        $ = require('atom-space-pen-views').$;
        wrappedStatusBar = $.extend($(this.statusBar), {
          appendLeft: (function(_this) {
            return function(view) {
              Grim.deprecate("Use ::addLeftTile({item, priority}) instead.");
              return _this.statusBar.appendLeft(view);
            };
          })(this),
          appendRight: (function(_this) {
            return function(view) {
              Grim.deprecate("Use ::addRightTile({item, priority}) instead.");
              return _this.statusBar.appendRight(view);
            };
          })(this),
          prependLeft: (function(_this) {
            return function(view) {
              Grim.deprecate("Use ::addLeftTile({item, priority}) instead.");
              return _this.statusBar.prependLeft(view);
            };
          })(this),
          prependRight: (function(_this) {
            return function(view) {
              Grim.deprecate("Use ::addRightTile({item, priority}) instead.");
              return _this.statusBar.prependRight(view);
            };
          })(this),
          getActiveBuffer: (function(_this) {
            return function() {
              return _this.statusBar.getActiveBuffer();
            };
          })(this),
          getActiveItem: (function(_this) {
            return function() {
              return _this.statusBar.getActiveItem();
            };
          })(this),
          subscribeToBuffer: (function(_this) {
            return function(event, callback) {
              return _this.statusBar.subscribeToBuffer(event, callback);
            };
          })(this)
        });
        if (atom.__workspaceView != null) {
          Object.defineProperty(atom.__workspaceView, 'statusBar', {
            get: function() {
              Grim.deprecate("The atom.workspaceView.statusBar global is deprecated. The global was\npreviously being assigned by the status-bar package, but Atom packages\nshould never assign globals.\n\nIn the future, this problem will be solved by an inter-package communication\nAPI available on `atom.services`. For now, you can get a reference to the\n`status-bar` element via `document.querySelector('status-bar')`.");
              return wrappedStatusBar;
            },
            configurable: true
          });
        }
      }
      atom.commands.add('atom-workspace', 'status-bar:toggle', (function(_this) {
        return function() {
          if (_this.statusBarPanel.isVisible()) {
            return _this.statusBarPanel.hide();
          } else {
            return _this.statusBarPanel.show();
          }
        };
      })(this));
      _ref = atom.getLoadSettings(), safeMode = _ref.safeMode, devMode = _ref.devMode;
      if (safeMode || devMode) {
        LaunchModeView = require('./launch-mode-view');
        launchModeView = new LaunchModeView();
        launchModeView.initialize({
          safeMode: safeMode,
          devMode: devMode
        });
        this.statusBar.addLeftTile({
          item: launchModeView,
          priority: -1
        });
      }
      this.fileInfo = new FileInfoView();
      this.fileInfo.initialize();
      this.statusBar.addLeftTile({
        item: this.fileInfo,
        priority: 0
      });
      this.cursorPosition = new CursorPositionView();
      this.cursorPosition.initialize();
      this.statusBar.addLeftTile({
        item: this.cursorPosition,
        priority: 1
      });
      this.selectionCount = new SelectionCountView();
      this.selectionCount.initialize();
      this.statusBar.addLeftTile({
        item: this.selectionCount,
        priority: 2
      });
      this.git = new GitView();
      this.git.initialize();
      return this.statusBar.addRightTile({
        item: this.git,
        priority: 0
      });
    },
    deactivate: function() {
      var _ref, _ref1, _ref2, _ref3, _ref4, _ref5;
      if ((_ref = this.git) != null) {
        _ref.destroy();
      }
      this.git = null;
      if ((_ref1 = this.fileInfo) != null) {
        _ref1.destroy();
      }
      this.fileInfo = null;
      if ((_ref2 = this.cursorPosition) != null) {
        _ref2.destroy();
      }
      this.cursorPosition = null;
      if ((_ref3 = this.selectionCount) != null) {
        _ref3.destroy();
      }
      this.selectionCount = null;
      if ((_ref4 = this.statusBarPanel) != null) {
        _ref4.destroy();
      }
      this.statusBarPanel = null;
      if ((_ref5 = this.statusBar) != null) {
        _ref5.destroy();
      }
      this.statusBar = null;
      if (atom.__workspaceView != null) {
        return delete atom.__workspaceView.statusBar;
      }
    },
    provideStatusBar: function() {
      return {
        addLeftTile: this.statusBar.addLeftTile.bind(this.statusBar),
        addRightTile: this.statusBar.addRightTile.bind(this.statusBar),
        getLeftTiles: this.statusBar.getLeftTiles.bind(this.statusBar),
        getRightTiles: this.statusBar.getRightTiles.bind(this.statusBar)
      };
    },
    legacyProvideStatusBar: function() {
      var statusbar;
      statusbar = this.provideStatusBar();
      return {
        addLeftTile: function() {
          var args;
          args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
          Grim.deprecate("Use version ^1.0.0 of the status-bar Service API.");
          return statusbar.addLeftTile.apply(statusbar, args);
        },
        addRightTile: function() {
          var args;
          args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
          Grim.deprecate("Use version ^1.0.0 of the status-bar Service API.");
          return statusbar.addRightTile.apply(statusbar, args);
        },
        getLeftTiles: function() {
          Grim.deprecate("Use version ^1.0.0 of the status-bar Service API.");
          return statusbar.getLeftTiles();
        },
        getRightTiles: function() {
          Grim.deprecate("Use version ^1.0.0 of the status-bar Service API.");
          return statusbar.getRightTiles();
        }
      };
    }
  };

}).call(this);
