(function() {
  var SelectionCountView,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  SelectionCountView = (function(_super) {
    __extends(SelectionCountView, _super);

    function SelectionCountView() {
      return SelectionCountView.__super__.constructor.apply(this, arguments);
    }

    SelectionCountView.prototype.initialize = function() {
      this.classList.add('selection-count', 'inline-block');
      this.activeItemSubscription = atom.workspace.onDidChangeActivePaneItem((function(_this) {
        return function() {
          return _this.subscribeToActiveTextEditor();
        };
      })(this));
      return this.subscribeToActiveTextEditor();
    };

    SelectionCountView.prototype.destroy = function() {
      var _ref;
      this.activeItemSubscription.dispose();
      return (_ref = this.selectionSubscription) != null ? _ref.dispose() : void 0;
    };

    SelectionCountView.prototype.subscribeToActiveTextEditor = function() {
      var _ref, _ref1;
      if ((_ref = this.selectionSubscription) != null) {
        _ref.dispose();
      }
      this.selectionSubscription = (_ref1 = this.getActiveTextEditor()) != null ? _ref1.onDidChangeSelectionRange((function(_this) {
        return function() {
          return _this.updateCount();
        };
      })(this)) : void 0;
      return this.updateCount();
    };

    SelectionCountView.prototype.getActiveTextEditor = function() {
      return atom.workspace.getActiveTextEditor();
    };

    SelectionCountView.prototype.updateCount = function() {
      var count, _ref;
      count = (_ref = this.getActiveTextEditor()) != null ? _ref.getSelectedText().length : void 0;
      if (count > 0) {
        return this.textContent = "(" + count + ")";
      } else {
        return this.textContent = '';
      }
    };

    return SelectionCountView;

  })(HTMLElement);

  module.exports = document.registerElement('status-bar-selection', {
    prototype: SelectionCountView.prototype,
    "extends": 'div'
  });

}).call(this);
