(function() {
  var $, Disposable, StatusBarView, Tile,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  $ = require('atom-space-pen-views').$;

  Disposable = require('atom').Disposable;

  Tile = require('./tile');

  StatusBarView = (function(_super) {
    __extends(StatusBarView, _super);

    function StatusBarView() {
      return StatusBarView.__super__.constructor.apply(this, arguments);
    }

    StatusBarView.prototype.createdCallback = function() {
      var flexboxHackElement;
      this.classList.add('status-bar');
      flexboxHackElement = document.createElement('div');
      flexboxHackElement.classList.add('flexbox-repaint-hack');
      this.appendChild(flexboxHackElement);
      this.leftPanel = document.createElement('div');
      this.leftPanel.classList.add('status-bar-left');
      flexboxHackElement.appendChild(this.leftPanel);
      this.rightPanel = document.createElement('div');
      this.rightPanel.classList.add('status-bar-right', 'pull-right');
      flexboxHackElement.appendChild(this.rightPanel);
      this.leftTiles = [];
      return this.rightTiles = [];
    };

    StatusBarView.prototype.initialize = function() {
      this.bufferSubscriptions = [];
      this.activeItemSubscription = atom.workspace.onDidChangeActivePaneItem((function(_this) {
        return function() {
          _this.unsubscribeAllFromBuffer();
          _this.storeActiveBuffer();
          _this.subscribeAllToBuffer();
          return _this.dispatchEvent(new CustomEvent('active-buffer-changed', {
            bubbles: true
          }));
        };
      })(this));
      this.storeActiveBuffer();
      return this;
    };

    StatusBarView.prototype.destroy = function() {
      this.activeItemSubscription.dispose();
      this.unsubscribeAllFromBuffer();
      return this.remove();
    };

    StatusBarView.prototype.addLeftTile = function(options) {
      var index, item, newElement, newItem, newPriority, newTile, nextElement, nextItem, priority, _i, _len, _ref, _ref1, _ref2;
      newItem = options.item;
      newPriority = (_ref = options != null ? options.priority : void 0) != null ? _ref : this.leftTiles[this.leftTiles.length - 1].priority + 1;
      nextItem = null;
      _ref1 = this.leftTiles;
      for (index = _i = 0, _len = _ref1.length; _i < _len; index = ++_i) {
        _ref2 = _ref1[index], priority = _ref2.priority, item = _ref2.item;
        if (priority > newPriority) {
          nextItem = item;
          break;
        }
      }
      newTile = new Tile(newItem, newPriority, this.leftTiles);
      this.leftTiles.splice(index, 0, newTile);
      newElement = atom.views.getView(newItem);
      nextElement = atom.views.getView(nextItem);
      this.leftPanel.insertBefore(newElement, nextElement);
      return newTile;
    };

    StatusBarView.prototype.addRightTile = function(options) {
      var index, item, newElement, newItem, newPriority, newTile, nextElement, nextItem, priority, _i, _len, _ref, _ref1, _ref2;
      newItem = options.item;
      newPriority = (_ref = options != null ? options.priority : void 0) != null ? _ref : this.rightTiles[0].priority + 1;
      nextItem = null;
      _ref1 = this.rightTiles;
      for (index = _i = 0, _len = _ref1.length; _i < _len; index = ++_i) {
        _ref2 = _ref1[index], priority = _ref2.priority, item = _ref2.item;
        if (priority < newPriority) {
          nextItem = item;
          break;
        }
      }
      newTile = new Tile(newItem, newPriority, this.rightTiles);
      this.rightTiles.splice(index, 0, newTile);
      newElement = atom.views.getView(newItem);
      nextElement = atom.views.getView(nextItem);
      this.rightPanel.insertBefore(newElement, nextElement);
      return newTile;
    };

    StatusBarView.prototype.getLeftTiles = function() {
      return this.leftTiles;
    };

    StatusBarView.prototype.getRightTiles = function() {
      return this.rightTiles;
    };

    StatusBarView.prototype.appendLeft = function(view) {
      return $(this.leftPanel).append(view);
    };

    StatusBarView.prototype.prependLeft = function(view) {
      return $(this.leftPanel).prepend(view);
    };

    StatusBarView.prototype.appendRight = function(view) {
      return $(this.rightPanel).append(view);
    };

    StatusBarView.prototype.prependRight = function(view) {
      return $(this.rightPanel).prepend(view);
    };

    StatusBarView.prototype.getActiveBuffer = function() {
      return this.buffer;
    };

    StatusBarView.prototype.getActiveItem = function() {
      return atom.workspace.getActivePaneItem();
    };

    StatusBarView.prototype.storeActiveBuffer = function() {
      var _ref;
      return this.buffer = (_ref = this.getActiveItem()) != null ? typeof _ref.getBuffer === "function" ? _ref.getBuffer() : void 0 : void 0;
    };

    StatusBarView.prototype.subscribeToBuffer = function(event, callback) {
      this.bufferSubscriptions.push([event, callback]);
      if (this.buffer) {
        return this.buffer.on(event, callback);
      }
    };

    StatusBarView.prototype.subscribeAllToBuffer = function() {
      var callback, event, _i, _len, _ref, _ref1, _results;
      if (!this.buffer) {
        return;
      }
      _ref = this.bufferSubscriptions;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        _ref1 = _ref[_i], event = _ref1[0], callback = _ref1[1];
        _results.push(this.buffer.on(event, callback));
      }
      return _results;
    };

    StatusBarView.prototype.unsubscribeAllFromBuffer = function() {
      var callback, event, _i, _len, _ref, _ref1, _results;
      if (!this.buffer) {
        return;
      }
      _ref = this.bufferSubscriptions;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        _ref1 = _ref[_i], event = _ref1[0], callback = _ref1[1];
        _results.push(this.buffer.off(event, callback));
      }
      return _results;
    };

    return StatusBarView;

  })(HTMLElement);

  module.exports = document.registerElement('status-bar', {
    prototype: StatusBarView.prototype
  });

}).call(this);
