(function() {
  var Grim, fs, os, path;

  Grim = require('grim');

  fs = require('fs-plus');

  path = require('path');

  os = require('os');

  describe("Status Bar package", function() {
    var editor, statusBar, statusBarService, workspaceElement, _ref;
    _ref = [], editor = _ref[0], statusBar = _ref[1], statusBarService = _ref[2], workspaceElement = _ref[3];
    beforeEach(function() {
      workspaceElement = atom.views.getView(atom.workspace);
      atom.__workspaceView = {};
      return waitsForPromise(function() {
        return atom.packages.activatePackage('status-bar').then(function(pack) {
          statusBar = workspaceElement.querySelector("status-bar");
          return statusBarService = pack.mainModule.provideStatusBar();
        });
      });
    });
    describe("@activate", function() {
      it("appends only one status bar", function() {
        expect(workspaceElement.querySelectorAll('status-bar').length).toBe(1);
        atom.workspace.getActivePane().splitRight({
          copyActiveItem: true
        });
        return expect(workspaceElement.querySelectorAll('status-bar').length).toBe(1);
      });
      return it("makes the status bar available as a deprecated property on atom.workspaceView", function() {
        spyOn(Grim, 'deprecate');
        expect(atom.__workspaceView.statusBar[0]).toBe(workspaceElement.querySelector(".status-bar"));
        expect(atom.__workspaceView.statusBar[0]).toBe(workspaceElement.querySelector("status-bar"));
        return expect(Grim.deprecate).toHaveBeenCalled();
      });
    });
    describe("@deactivate()", function() {
      return it("removes the status bar view", function() {
        atom.packages.deactivatePackage("status-bar");
        expect(workspaceElement.querySelector('status-bar')).toBeNull();
        return expect(atom.__workspaceView.statusBar).toBeFalsy();
      });
    });
    describe("when status-bar:toggle is triggered", function() {
      beforeEach(function() {
        return jasmine.attachToDOM(workspaceElement);
      });
      return it("hides or shows the status bar", function() {
        atom.commands.dispatch(workspaceElement, 'status-bar:toggle');
        expect(workspaceElement.querySelector('status-bar').parentNode).not.toBeVisible();
        atom.commands.dispatch(workspaceElement, 'status-bar:toggle');
        return expect(workspaceElement.querySelector('status-bar').parentNode).toBeVisible();
      });
    });
    return describe("the 'status-bar' service", function() {
      return it("allows tiles to be added, removed, and retrieved", function() {
        var dummyView, tile;
        dummyView = document.createElement("div");
        tile = statusBarService.addLeftTile({
          item: dummyView
        });
        expect(statusBar).toContain(dummyView);
        expect(statusBarService.getLeftTiles()).toContain(tile);
        tile.destroy();
        expect(statusBar).not.toContain(dummyView);
        expect(statusBarService.getLeftTiles()).not.toContain(tile);
        dummyView = document.createElement("div");
        tile = statusBarService.addRightTile({
          item: dummyView
        });
        expect(statusBar).toContain(dummyView);
        expect(statusBarService.getRightTiles()).toContain(tile);
        tile.destroy();
        expect(statusBar).not.toContain(dummyView);
        return expect(statusBarService.getRightTiles()).not.toContain(tile);
      });
    });
  });

}).call(this);
