(function() {
  var $$, ExampleSection;

  $$ = require('atom-space-pen-views').$$;

  module.exports = ExampleSection = (function() {
    ExampleSection.prototype.loaded = false;

    ExampleSection.build = function(view, name, title, buildFn) {
      var sectionEl;
      sectionEl = $$(function() {
        return this.section({
          "class": 'bordered collapsed',
          'data-name': name
        }, (function(_this) {
          return function() {
            return _this.h1({
              "class": 'section-heading'
            }, title);
          };
        })(this));
      });
      return new ExampleSection(name, sectionEl, buildFn);
    };

    function ExampleSection(name, el, buildFn) {
      this.name = name;
      this.el = el;
      this.buildFn = buildFn;
    }

    ExampleSection.prototype.load = function() {
      var self;
      if (this.loaded) {
        return;
      }
      self = this;
      this.el.append($$(function() {
        return self.buildFn.call(this);
      }));
      return this.loaded = true;
    };

    ExampleSection.prototype.toggle = function() {
      if (this.el.hasClass('collapsed')) {
        return this.expand();
      } else {
        return this.collapse();
      }
    };

    ExampleSection.prototype.collapse = function() {
      return this.el.addClass('collapsed');
    };

    ExampleSection.prototype.expand = function() {
      this.load();
      return this.el.removeClass('collapsed');
    };

    return ExampleSection;

  })();

}).call(this);
