(function() {
  var $, $$, $$$, ExampleSelectListView, Highlights, View, beautifyHtml, coffee, highlighter, _, _ref;

  _ = require('underscore-plus');

  _ref = require('atom-space-pen-views'), $ = _ref.$, $$ = _ref.$$, $$$ = _ref.$$$, View = _ref.View;

  coffee = require('coffee-script');

  beautifyHtml = require('js-beautify').html;

  Highlights = require('highlights');

  ExampleSelectListView = require('./example-select-list-view');

  highlighter = null;

  _.extend(View, {
    exampleHtml: function(html) {
      return this.div({
        "class": 'example'
      }, (function(_this) {
        return function() {
          _this.div({
            "class": 'example-rendered'
          }, function() {
            return _this.raw(html);
          });
          return _this.div({
            "class": 'example-code show-example-html'
          }, function() {
            return _this.colorizedCodeBlock('example-html', 'text.xml', beautifyHtml(html));
          });
        };
      })(this));
    },
    exampleOverlaySelectList: function() {
      var coffeeScript, selectList;
      selectList = new ExampleSelectListView(['one', 'two', 'three']);
      coffeeScript = "{SelectListView, $$} = require 'atom-space-pen-views'\n\nmodule.exports =\nclass ExampleSelectListView extends SelectListView\n  initialize: (@listOfItems) ->\n    super\n    @setItems(@listOfItems)\n\n  viewForItem: (item) ->\n    $$ -> @li(item)\n\n  cancel: ->\n    console.log(\"cancelled\")\n\n  confirmed: (item) ->\n    console.log(\"confirmed\", item)";
      return this.div({
        "class": 'example'
      }, (function(_this) {
        return function() {
          _this.div({
            "class": 'example-rendered'
          }, function() {
            return _this.tag('atom-panel', {
              "class": 'modal'
            }, function() {
              return _this.subview('__', selectList);
            });
          });
          return _this.div({
            "class": 'example-code show-example-space-pen'
          }, function() {
            return _this.colorizedCodeBlock('example-space-pen', 'source.coffee', coffeeScript);
          });
        };
      })(this));
    },
    colorizedCodeBlock: function(cssClass, grammarScopeName, code) {
      var fontFamily, highlightedBlock, highlightedHtml;
      if (highlighter == null) {
        highlighter = new Highlights({
          registry: atom.grammars
        });
      }
      highlightedHtml = highlighter.highlightSync({
        fileContents: code,
        scopeName: grammarScopeName
      });
      highlightedBlock = $(highlightedHtml);
      highlightedBlock.removeClass('editor');
      highlightedBlock.addClass(cssClass);
      if (fontFamily = atom.config.get('editor.fontFamily')) {
        highlightedBlock.css('font-family', fontFamily);
      }
      return this.subview('__', highlightedBlock);
    }
  });

}).call(this);
