(function() {
  var $, Disposable, ExampleSection, ScrollView, StyleguideView, _ref,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  Disposable = require('atom').Disposable;

  _ref = require('atom-space-pen-views'), $ = _ref.$, ScrollView = _ref.ScrollView;

  require('./space-pen-extensions');

  ExampleSection = require('./example-section');

  module.exports = StyleguideView = (function(_super) {
    __extends(StyleguideView, _super);

    function StyleguideView() {
      this.collapseAllSections = __bind(this.collapseAllSections, this);
      return StyleguideView.__super__.constructor.apply(this, arguments);
    }

    StyleguideView.content = function() {
      return this.div({
        "class": 'styleguide pane-item native-key-bindings padded',
        tabindex: -1
      }, (function(_this) {
        return function() {
          _this.button({
            outlet: 'collapseAllButton',
            "class": 'btn btn-collapse-all'
          }, 'Collapse All Sections');
          _this.exampleSection('styleguide', 'Styleguide', function() {
            return this.p('This exercises all UI components and acts as a styleguide.');
          });
          _this.exampleSection('variables', 'Variables', function() {
            this.p((function(_this) {
              return function() {
                return _this.raw('Use these UI variables in your package\'s stylesheets. They are set by UI themes and therefore your package will match the overall look.');
              };
            })(this));
            this.div({
              "class": 'variables-group'
            }, (function(_this) {
              return function() {
                _this.h2('Text colors');
                return _this.exampleHtml('<div class="is-color text-color">@text-color</div>\n<div class="is-color text-color-subtle">@text-color-subtle</div>\n<div class="is-color text-color-highlight">@text-color-highlight</div>\n<div class="is-color text-color-selected">@text-color-selected</div>\n<div class="is-color"></div>\n<div class="is-color text-color-info">@text-color-info</div>\n<div class="is-color text-color-success">@text-color-success</div>\n<div class="is-color text-color-warning">@text-color-warning</div>\n<div class="is-color text-color-error">@text-color-error</div>');
              };
            })(this));
            this.div({
              "class": 'variables-group'
            }, (function(_this) {
              return function() {
                _this.h2('Background colors');
                return _this.exampleHtml('<div class="is-color background-color-info">@background-color-info</div>\n<div class="is-color background-color-success">@background-color-success</div>\n<div class="is-color background-color-warning">@background-color-warning</div>\n<div class="is-color background-color-error">@background-color-error</div>\n<div class="is-color"></div>\n<div class="is-color background-color-highlight">@background-color-highlight</div>\n<div class="is-color background-color-selected">@background-color-selected</div>\n<div class="is-color app-background-color">@app-background-color</div>');
              };
            })(this));
            this.div({
              "class": 'variables-group'
            }, (function(_this) {
              return function() {
                _this.h2('Base colors');
                return _this.exampleHtml('<div class="is-color base-background-color">@base-background-color</div>\n<div class="is-color base-border-color">@base-border-color</div>');
              };
            })(this));
            this.div({
              "class": 'variables-group'
            }, (function(_this) {
              return function() {
                _this.h2('Component colors');
                return _this.exampleHtml('<div class="is-color pane-item-background-color">@pane-item-background-color</div>\n<div class="is-color pane-item-border-color">@pane-item-border-color</div>\n<div class="is-color"></div>\n<div class="is-color input-background-color">@input-background-color</div>\n<div class="is-color input-border-color">@input-border-color</div>\n<div class="is-color"></div>\n<div class="is-color tool-panel-background-color">@tool-panel-background-color</div>\n<div class="is-color tool-panel-border-color">@tool-panel-border-color</div>\n<div class="is-color inset-panel-background-color">@inset-panel-background-color</div>\n<div class="is-color inset-panel-border-color">@inset-panel-border-color</div>\n<div class="is-color panel-heading-background-color">@panel-heading-background-color</div>\n<div class="is-color panel-heading-border-color">@panel-heading-border-color</div>\n<div class="is-color overlay-background-color">@overlay-background-color</div>\n<div class="is-color overlay-border-color">@overlay-border-color</div>\n<div class="is-color"></div>\n<div class="is-color button-background-color">@button-background-color</div>\n<div class="is-color button-background-color-hover">@button-background-color-hover</div>\n<div class="is-color button-background-color-selected">@button-background-color-selected</div>\n<div class="is-color button-border-color">@button-border-color</div>\n<div class="color"></div>\n<div class="is-color tab-bar-background-color">@tab-bar-background-color</div>\n<div class="is-color tab-bar-border-color">@tab-bar-border-color</div>\n<div class="is-color tab-background-color">@tab-background-color</div>\n<div class="is-color tab-background-color-active">@tab-background-color-active</div>\n<div class="is-color tab-border-color">@tab-border-color</div>\n<div class="is-color"></div>\n<div class="is-color tree-view-background-color">@tree-view-background-color</div>\n<div class="is-color tree-view-border-color">@tree-view-border-color</div>');
              };
            })(this));
            this.div({
              "class": 'variables-group'
            }, (function(_this) {
              return function() {
                _this.h2('Site colors');
                return _this.exampleHtml('<div class="is-color ui-site-color-1">@ui-site-color-1</div>\n<div class="is-color ui-site-color-2">@ui-site-color-2</div>\n<div class="is-color ui-site-color-3">@ui-site-color-3</div>\n<div class="is-color ui-site-color-4">@ui-site-color-4</div>\n<div class="is-color ui-site-color-5">@ui-site-color-5</div>');
              };
            })(this));
            this.div({
              "class": 'variables-group'
            }, (function(_this) {
              return function() {
                _this.h2('Sizes');
                return _this.exampleHtml('<div class="is-size disclosure-arrow-size">@disclosure-arrow-size</div>\n<div class="is-size component-padding">@component-padding</div>\n<div class="is-size component-icon-padding">@component-icon-padding</div>\n<div class="is-size component-icon-size">@component-icon-size</div>\n<div class="is-size component-line-height">@component-line-height</div>\n<div class="is-size tab-height">@tab-height</div>\n<div class="is-size font-size">@font-size</div>');
              };
            })(this));
            return this.div({
              "class": 'variables-group'
            }, (function(_this) {
              return function() {
                _this.h2('Misc');
                return _this.exampleHtml('<div class="is-radius component-border-radius">@component-border-radius</div>\n<div class="is-font font-family">@font-family</div>');
              };
            })(this));
          });
          _this.exampleSection('text', 'Text classes', function() {
            this.p((function(_this) {
              return function() {
                return _this.raw('There are a number of text classes.');
              };
            })(this));
            this.h2('text-* classes');
            this.exampleHtml('<div class=\'text-smaller\'>Smaller text</div>\n<div>Normal text</div>\n<div class=\'text-subtle\'>Subtle text</div>\n<div class=\'text-highlight\'>Highlighted text</div>\n<div class=\'text-info\'>Info text</div>\n<div class=\'text-success\'>Success text</div>\n<div class=\'text-warning\'>Warning text</div>\n<div class=\'text-error\'>Error text</div>');
            this.h2('highlight-* classes');
            return this.exampleHtml('<span class=\'inline-block\'>Normal</span>\n<span class=\'inline-block highlight\'>Highlighted</span>\n<span class=\'inline-block highlight-info\'>Info</span>\n<span class=\'inline-block highlight-success\'>Success</span>\n<span class=\'inline-block highlight-warning\'>Warning</span>\n<span class=\'inline-block highlight-error\'>Error</span>');
          });
          _this.exampleSection('layout', 'Layout classes', function() {
            this.p((function(_this) {
              return function() {
                return _this.raw('A few things that might be useful for general layout.');
              };
            })(this));
            this.h2('.block');
            this.p('Sometimes you need to separate components vertically. Say in a form.');
            this.exampleHtml('<div class=\'block\'>\n  <label>You might want to type something here.</label>\n  <atom-text-editor mini>Something you typed...</atom-text-editor>\n</div>\n<div class=\'block\'>\n  <label class=\'icon icon-file-directory\'>Another field with an icon</label>\n  <atom-text-editor mini>Something else you typed...</atom-text-editor>\n</div>\n<div class=\'block\'>\n  <button class=\'btn\'>Do it</button>\n</div>');
            this.h2('.inline-block');
            this.p('Sometimes you need to separate components horizontally.');
            this.exampleHtml('<div class=\'block\'>\n  <label>This is a thing with stuff in it</label>\n  <div>\n    <atom-text-editor mini class=\'inline-block\'>Something you typed...</atom-text-editor>\n    <div class=\'inline-block btn-group\'>\n      <button class=\'btn\'>One</button>\n      <button class=\'btn\'>Two</button>\n    </div>\n  </div>\n</div>\n<div class=\'block\'>\n  <button class=\'inline-block btn\'>Do it</button>\n  <button class=\'inline-block btn\'>Another</button>\n  <button class=\'inline-block btn\'>OMG again</button>\n</div>');
            this.h2('.inline-block-tight');
            this.p('You might want things to be a little closer to each other.');
            return this.exampleHtml('<div class=\'block\'>\n  <button class=\'inline-block-tight btn\'>Do it</button>\n  <button class=\'inline-block-tight btn\'>Another</button>\n  <button class=\'inline-block-tight btn\'>OMG again</button>\n</div>');
          });
          _this.exampleSection('git', 'Git related classes', function() {
            this.p((function(_this) {
              return function() {
                return _this.raw('Often we need git related classes to specify status.');
              };
            })(this));
            this.h2('status-* classes');
            this.exampleHtml('<div class=\'status-ignored\'>Ignored</div>\n<div class=\'status-added\'>Added</div>\n<div class=\'status-modified\'>Modified</div>\n<div class=\'status-removed\'>Removed</div>\n<div class=\'status-renamed\'>Renamed</div>');
            this.h2('status-* classes with related icons');
            return this.exampleHtml('<span class=\'inline-block status-ignored icon icon-diff-ignored\'></span>\n<span class=\'inline-block status-added icon icon-diff-added\'></span>\n<span class=\'inline-block status-modified icon icon-diff-modified\'></span>\n<span class=\'inline-block status-removed icon icon-diff-removed\'></span>\n<span class=\'inline-block status-renamed icon icon-diff-renamed\'></span>');
          });
          _this.exampleSection('site-highlight', 'Site colors', function() {
            this.p((function(_this) {
              return function() {
                return _this.raw('Site colors are used for collaboration. A site is another collaborator.');
              };
            })(this));
            this.h2('ui-site-* classes');
            this.p((function(_this) {
              return function() {
                return _this.raw('These classes only set the background color, no other styles.\nYou can also use LESS variables <code>@ui-site-#</code> in your plugins where\n<code>#</code> is a number between 1 and 5.');
              };
            })(this));
            this.p((function(_this) {
              return function() {
                return _this.raw('Site colors will always be in the color progression you see here.');
              };
            })(this));
            return this.exampleHtml('<div class=\'block ui-site-1\'></div>\n<div class=\'block ui-site-2\'></div>\n<div class=\'block ui-site-3\'></div>\n<div class=\'block ui-site-4\'></div>\n<div class=\'block ui-site-5\'></div>');
          });
          _this.exampleSection('badges', 'Badges', function() {
            this.p((function(_this) {
              return function() {
                return _this.raw('Badges are typically used to show numbers.');
              };
            })(this));
            this.h2('Standalone badges');
            this.exampleHtml('<div class=\'block\'>\n  <span class=\'badge\'>0</span>\n  <span class=\'badge\'>8</span>\n  <span class=\'badge\'>27</span>\n  <span class=\'badge\'>450</span>\n  <span class=\'badge\'>2869</span>\n</div>');
            this.h2('Colored badges');
            this.exampleHtml('<div class=\'block\'>\n  <span class=\'badge badge-info\'>78</span>\n  <span class=\'badge badge-success\'>3</span>\n  <span class=\'badge badge-warning\'>14</span>\n  <span class=\'badge badge-error\'>1845</span>\n</div>');
            this.h2('Badge sizes');
            this.p((function(_this) {
              return function() {
                return _this.raw('By default the <code>@font-size</code> variable from themes is used. Additionally there are also 3 predefined sizes.');
              };
            })(this));
            this.exampleHtml('<div class=\'block\'>Large <span class=\'badge badge-large\'>8</span></div>\n<div class=\'block\'>Medium <span class=\'badge badge-medium\'>2</span></div>\n<div class=\'block\'>Small <span class=\'badge badge-small\'>7</span></div>');
            this.p((function(_this) {
              return function() {
                return _this.raw('If you like the size change depending on the parent, use the <code>badge-flexible</code> class. Note: Best used for larger sizes. For smaller sizes it could cause the number to be mis-aligned by a pixel.');
              };
            })(this));
            this.exampleHtml('<h1 class=\'block\'>Heading <span class=\'badge badge-flexible\'>1</span></h1>\n<h2 class=\'block\'>Heading <span class=\'badge badge-flexible\'>2</span></h2>\n<h3 class=\'block\'>Heading <span class=\'badge badge-flexible\'>3</span></h3>');
            this.h2('Icon Badges');
            this.p((function(_this) {
              return function() {
                return _this.raw('Overview of all <a href="https://octicons.github.com/">Octicons</a>.');
              };
            })(this));
            return this.exampleHtml('<div class=\'block\'>\n  <span class=\'badge icon icon-gear\'>4</span>\n  <span class=\'badge badge-info icon icon-cloud-download\'>13</span>\n  <span class=\'badge badge-success icon icon-octoface\'>5</span>\n</div>');
          });
          _this.exampleSection('buttons', 'Buttons', function() {
            this.p((function(_this) {
              return function() {
                return _this.raw('Buttons are similar to bootstrap buttons');
              };
            })(this));
            this.h2('Standalone buttons');
            this.exampleHtml('<div class=\'block\'>\n  <button class=\'btn\'>Button</button>\n</div>\n<div class=\'block\'>\n  <button class=\'btn btn-xs\'>Extra Small Button</button>\n</div>\n<div class=\'block\'>\n  <button class=\'btn btn-sm\'>Small Button</button>\n</div>\n<div class=\'block\'>\n  <button class=\'btn btn-lg\'>Large Button</button>\n</div>');
            this.h2('Colored buttons');
            this.exampleHtml('<div class=\'block\'>\n  <button class=\'btn btn-primary inline-block-tight\'>Primary</button>\n  <button class=\'btn btn-primary selected inline-block-tight\'>Selected Primary</button>\n</div>\n\n<div class=\'block\'>\n  <button class=\'btn btn-info inline-block-tight\'>Info</button>\n  <button class=\'btn btn-info selected inline-block-tight\'>Selected Info</button>\n</div>\n\n<div class=\'block\'>\n  <button class=\'btn btn-success inline-block-tight\'>Success</button>\n  <button class=\'btn btn-success selected inline-block-tight\'>Selected Success</button>\n</div>\n\n<div class=\'block\'>\n  <button class=\'btn btn-warning inline-block-tight\'>Warning</button>\n  <button class=\'btn btn-warning selected inline-block-tight\'>Selected Warning</button>\n</div>\n\n<div class=\'block\'>\n  <button class=\'btn btn-error inline-block-tight\'>Error</button>\n  <button class=\'btn btn-error selected inline-block-tight\'>Selected Error</button>\n</div>');
            this.h2('Icon buttons');
            this.p((function(_this) {
              return function() {
                return _this.raw('Overview of all <a href="https://octicons.github.com/">Octicons</a>.');
              };
            })(this));
            this.exampleHtml('<div class=\'block\'>\n  <button class=\'btn icon icon-gear inline-block-tight\'>Settings</button>\n  <button class=\'btn btn-primary icon icon-cloud-download inline-block-tight\'>Install</button>\n  <button class=\'btn btn-error icon icon-octoface inline-block-tight\'>Danger</button>\n</div>');
            this.h2('Button Groups');
            this.exampleHtml('<div class=\'block\'>\n  <div>Normal size</div>\n  <div class=\'btn-group\'>\n    <button class=\'btn\'>One</button>\n    <button class=\'btn\'>Two</button>\n    <button class=\'btn\'>Three</button>\n  </div>\n</div>\n\n<div class=\'block\'>\n  <div>Extra Small</div>\n  <div class=\'btn-group btn-group-xs\'>\n    <button class=\'btn\'>One</button>\n    <button class=\'btn\'>Two</button>\n    <button class=\'btn\'>Three</button>\n  </div>\n</div>\n\n<div class=\'block\'>\n  <div>Small</div>\n  <div class=\'btn-group btn-group-sm\'>\n    <button class=\'btn\'>One</button>\n    <button class=\'btn\'>Two</button>\n    <button class=\'btn\'>Three</button>\n  </div>\n</div>\n\n<div class=\'block\'>\n  <div>Large</div>\n  <div class=\'btn-group btn-group-lg\'>\n    <button class=\'btn\'>One</button>\n    <button class=\'btn\'>Two</button>\n    <button class=\'btn\'>Three</button>\n  </div>\n</div>');
            this.h2('Button Toolbars');
            this.exampleHtml('<div class=\'btn-toolbar\'>\n  <div class=\'btn-group\'>\n    <button class=\'btn\'>One</button>\n    <button class=\'btn\'>Two</button>\n    <button class=\'btn\'>Three</button>\n  </div>\n\n  <div class=\'btn-group\'>\n    <button class=\'btn\'>Four</button>\n    <button class=\'btn\'>Five</button>\n  </div>\n\n  <button class=\'btn\'>Six</button>\n  <button class=\'btn\'>Seven</button>\n</div>');
            this.h2('Selected buttons');
            this.p((function(_this) {
              return function() {
                return _this.raw('Buttons can be marked selected by adding a <code>.selected</code> class. Useful for toggle groups.');
              };
            })(this));
            return this.exampleHtml('<div class=\'block\'>\n  <div class=\'btn-group\'>\n    <button class=\'btn selected\'>One</button>\n    <button class=\'btn\'>Two</button>\n    <button class=\'btn\'>Three</button>\n  </div>\n</div>\n\n<div class=\'block\'>\n  <div class=\'btn-group\'>\n    <button class=\'btn\'>One</button>\n    <button class=\'btn selected\'>Two</button>\n    <button class=\'btn\'>Three</button>\n  </div>\n</div>\n\n<div class=\'block\'>\n  <div class=\'btn-group\'>\n    <button class=\'btn\'>One</button>\n    <button class=\'btn\'>Two</button>\n    <button class=\'btn selected\'>Three</button>\n  </div>\n</div>\n\n<div class=\'block\'>\n  <div class=\'btn-group\'>\n    <button class=\'btn selected\'>One</button>\n    <button class=\'btn selected\'>Two</button>\n    <button class=\'btn\'>Three</button>\n  </div>\n</div>');
          });
          _this.exampleSection('panel', 'Panels', function() {
            this.p('A container attached to some side of the Atom UI.');
            return this.exampleHtml('<atom-panel class=\'top\'>\n  Some content\n</atom-panel>');
          });
          _this.exampleSection('inset-panel', 'Inset Panel', function() {
            this.p('Use inside a panel');
            this.exampleHtml('<atom-panel class=\'top\'>\n  <div class="padded">\n    <div class="inset-panel padded">Some inset content</div>\n  </div>\n</atom-panel>');
            this.h2('With a heading');
            return this.exampleHtml('<atom-panel class=\'top\'>\n  <div class="padded">\n    <div class="inset-panel">\n      <div class="panel-heading">An inset-panel heading</div>\n      <div class="panel-body padded">Some Content</div>\n    </div>\n  </div>\n</atom-panel>');
          });
          _this.exampleSection('list-group', 'List Group', function() {
            this.p('Use for anything that requires a list.');
            this.exampleHtml('<ul class=\'list-group\'>\n  <li class=\'list-item\'>Normal item</li>\n  <li class=\'list-item selected\'>This is the Selected item</li>\n  <li class=\'list-item text-subtle\'>Subtle</li>\n  <li class=\'list-item text-info\'>Info</li>\n  <li class=\'list-item text-success\'>Success</li>\n  <li class=\'list-item text-warning\'>Warning</li>\n  <li class=\'list-item text-error\'>Error</li>\n</ul>');
            this.h2('With icons');
            return this.exampleHtml('<ul class=\'list-group\'>\n  <li class=\'list-item\'>\n    <span class=\'icon icon-file-directory\'>Using a span with an icon</span>\n  </li>\n\n  <li class=\'list-item\'>\n    <i class=\'icon icon-file-directory\'></i>\n    <span>With .icon-file-directory using &lt;i%gt; tags</span>\n  </li>\n\n  <li class=\'list-item selected\'>\n    <span class=\'icon icon-file-directory\'>Selected with .icon-file-directory</span>\n  </li>\n\n  <li class=\'list-item\'>\n    <span class=\'no-icon\'>With .no-icon</span>\n  </li>\n\n  <li class=\'list-item\'>\n    <span class=\'icon icon-file-text\'>With icon-file-text</span>\n  </li>\n\n  <li class=\'list-item\'>\n    <span class=\'icon icon-file-media\'>With icon-file-media</span>\n  </li>\n\n  <li class=\'list-item\'>\n    <span class=\'icon icon-file-symlink-file\'>With icon-file-symlink-file</span>\n  </li>\n\n  <li class=\'list-item\'>\n    <span class=\'icon icon-file-submodule\'>With icon-file-submodule</span>\n  </li>\n\n  <li class=\'list-item\'>\n    <span class=\'icon icon-book\'>With icon-book</span>\n  </li>\n</ul>');
          });
          _this.exampleSection('list-tree', 'List Tree', function() {
            this.p((function(_this) {
              return function() {
                return _this.raw('A <code>.list-tree</code> is a special case of <code>.list-group</code>.');
              };
            })(this));
            this.exampleHtml('<ul class=\'list-tree\'>\n  <li class=\'list-nested-item\'>\n    <div class=\'list-item\'>\n      <span class=\'icon icon-file-directory\'>A Directory</span>\n    </div>\n\n    <ul class=\'list-tree\'>\n      <li class=\'list-nested-item\'>\n        <div class=\'list-item\'>\n          <span class=\'icon icon-file-directory\'>Nested Directory</span>\n        </div>\n\n        <ul class=\'list-tree\'>\n          <li class=\'list-item\'>\n            <span class=\'icon icon-file-text\'>File one</span>\n          </li>\n        </ul>\n      </li>\n\n      <li class=\'list-nested-item collapsed\'>\n        <div class=\'list-item\'>\n          <span class=\'icon icon-file-directory\'>Collpased Nested Directory</span>\n        </div>\n\n        <ul class=\'list-tree\'>\n          <li class=\'list-item\'>\n            <span class=\'icon icon-file-text\'>File one</span>\n          </li>\n        </ul>\n      </li>\n\n      <li class=\'list-item\'>\n        <span class=\'icon icon-file-text\'>File one</span>\n      </li>\n\n      <li class=\'list-item selected\'>\n        <span class=\'icon icon-file-text\'>File three .selected!</span>\n      </li>\n    </ul>\n  </li>\n\n  <li class=\'list-item\'>\n    <span class=\'icon icon-file-text\'>.icon-file-text</span>\n  </li>\n\n  <li class=\'list-item\'>\n    <span class=\'icon icon-file-symlink-file\'>.icon-file-symlink-file</span>\n  </li>');
            this.h2('With disclosure arrows');
            this.p((function(_this) {
              return function() {
                return _this.raw('Add the class <code>.has-collapsable-children</code> to give the children with nested items disclosure arrows.');
              };
            })(this));
            this.exampleHtml('<ul class=\'list-tree has-collapsable-children\'>\n  <li class=\'list-nested-item\'>\n    <div class=\'list-item\'>\n      <span class=\'icon icon-file-directory\'>A Directory</span>\n    </div>\n\n    <ul class=\'list-tree\'>\n      <li class=\'list-nested-item\'>\n        <div class=\'list-item\'>\n          <span class=\'icon icon-file-directory\'>Nested Directory</span>\n        </div>\n\n        <ul class=\'list-tree\'>\n          <li class=\'list-item\'>\n            <span class=\'icon icon-file-text\'>File one</span>\n          </li>\n        </ul>\n      </li>\n\n      <li class=\'list-nested-item collapsed\'>\n        <div class=\'list-item\'>\n          <span class=\'icon icon-file-directory\'>Collpased Nested Directory</span>\n        </div>\n\n        <ul class=\'list-tree\'>\n          <li class=\'list-item\'>\n            <span class=\'icon icon-file-text\'>File one</span>\n          </li>\n        </ul>\n      </li>\n\n      <li class=\'list-item\'>\n        <span class=\'icon icon-file-text\'>File one</span>\n      </li>\n\n      <li class=\'list-item selected\'>\n        <span class=\'icon icon-file-text\'>File three .selected!</span>\n      </li>\n    </ul>\n  </li>\n\n  <li class=\'list-item\'>\n    <span class=\'icon icon-file-text\'>.icon-file-text</span>\n  </li>\n\n  <li class=\'list-item\'>\n    <span class=\'icon icon-file-symlink-file\'>.icon-file-symlink-file</span>\n  </li>\n</ul>');
            this.h2('With disclosure arrows at only one level.');
            this.p((function(_this) {
              return function() {
                return _this.raw('Add the class <code>.has-flat-children</code> to sub-<code>.list-tree</code>s to indicate that the children will not be collapsable.');
              };
            })(this));
            return this.exampleHtml('<ul class=\'list-tree has-collapsable-children \'>\n  <li class=\'list-nested-item\'>\n    <div class=\'list-item\'>\n      <span class=\'icon icon-file-text\'>This is a collapsable section</span>\n    </div>\n\n    <ul class=\'list-tree has-flat-children\'>\n      <li class=\'list-item\'>Something is here</li>\n      <li class=\'list-item selected\'>Something selected</li>\n    </ul>\n  </li>\n\n  <li class=\'list-nested-item\'>\n    <div class=\'list-item\'>\n      <span class=\'icon icon-file-directory\'>Another collapsable section</span>\n    </div>\n\n    <ul class=\'list-tree has-flat-children\'>\n      <li class=\'list-item\'>Something is here</li>\n      <li class=\'list-item\'>Something else</li>\n    </ul>\n  </li>\n</ul>');
          });
          _this.exampleSection('modal-panel', 'Modals', function() {
            this.p((function(_this) {
              return function() {
                return _this.raw('Modals are like dialog boxes.');
              };
            })(this));
            this.p((function(_this) {
              return function() {
                return _this.raw('Supported classes: <code>.from-top</code>, <code>.from-bottom</code> and <code>.floating</code>.\n<code>.from-top</code> will come down from the top of the UI, etc.');
              };
            })(this));
            return this.exampleHtml('<atom-panel class=\'modal\'>\n  <div>Some content</div>\n</atom-panel>');
          });
          _this.exampleSection('select-list', 'Select List', function() {
            this.p((function(_this) {
              return function() {
                return _this.raw('You wont be creating a <code>.select-list</code> directly, but will do so\nby extending the <code>SelectListView</code> class. Your\n<code>SelectListView</code> will usually specify only the list items,\nand hide/show the errors or loading message.');
              };
            })(this));
            this.p((function(_this) {
              return function() {
                return _this.raw('This is how you will typically specify a <code>.select-list</code>.');
              };
            })(this));
            this.exampleOverlaySelectList();
            this.p((function(_this) {
              return function() {
                return _this.raw('The list items have many options you can use, and shows you how they will display.');
              };
            })(this));
            this.h2('Basic example with one item selected');
            this.exampleHtml('<atom-panel class=\'modal\'>\n  <div class=\'select-list\'>\n    <ol class=\'list-group\'>\n      <li class=\'selected\'>one</li>\n      <li>two</li>\n      <li>three</li>\n    </ol>\n  </div>\n</atom-panel>');
            this.h2('Single line with icons');
            this.exampleHtml('<atom-panel class=\'modal\'>\n  <div class=\'select-list\'>\n    <ol class=\'list-group\'>\n      <li class=\'selected\'>\n        <div class=\'status status-added icon icon-diff-added\'></div>\n        <div class=\'icon icon-file-text\'>Some file</div>\n      </li>\n\n      <li>\n        <div class=\'status status-modified icon icon-diff-modified\'></div>\n        <div class=\'icon icon-file-text\'>Another file</div>\n      </li>\n\n      <li>\n        <div class=\'status status-removed icon icon-diff-removed\'></div>\n        <div class=\'icon icon-file-text\'>Yet another file</div>\n      </li>\n    </ol>\n  </div>\n</atom-panel>');
            this.h2('Single line with key-bindings');
            this.exampleHtml('<atom-panel class=\'modal\'>\n  <div class=\'select-list\'>\n    <ol class=\'list-group\'>\n      <li class=\'selected\'>\n        <div class=\'pull-right\'>\n          <kbd class=\'key-binding pull-right\'>⌘⌥↓</kbd>\n        </div>\n\n        <span class=\'icon icon-file-text\'>Some file</span>\n      </li>\n\n      <li>\n        <div class=\'pull-right key-bindings\'>\n          <kbd class=\'key-binding\'>⌘⌥A</kbd>\n          <kbd class=\'key-binding\'>⌘⌥O</kbd>\n          <kbd class=\'key-binding\'>⌘⌥1</kbd>\n          <kbd class=\'key-binding\'>⌘⌥↓</kbd>\n          <kbd class=\'key-binding\'>⌘⌥5</kbd>\n          <kbd class=\'key-binding\'>⌘⌥↓</kbd>\n        </div>\n\n        <span class=\'icon icon-file-text\'>Another file with a long name</span>\n      </li>\n\n      <li>\n        <div class=\'pull-right\'>\n          <kbd class=\'key-binding\'>⌘⌥↓</kbd>\n        </div>\n\n        <span class=\'icon icon-file-text\'>Yet another file</span>\n      </li>\n    </ol>\n  </div>\n</atom-panel>');
            this.h2('Multiple lines with no icons');
            this.exampleHtml('<atom-panel class=\'modal\'>\n  <div class=\'select-list\'>\n    <ol class=\'list-group\'>\n      <li class=\'two-lines\'>\n        <div class=\'primary-line\'>Primary line</div>\n        <div class=\'secondary-line\'>Secondary line</div>\n      </li>\n\n      <li class=\'two-lines selected\'>\n        <div class=\'primary-line\'>A thing</div>\n        <div class=\'secondary-line\'>Description of the thing</div>\n      </li>\n    </ol>\n  </div>\n</atom-panel>');
            this.h2('Multiple lines with icons');
            this.exampleHtml('<atom-panel class=\'modal\'>\n  <div class=\'select-list\'>\n    <ol class=\'list-group\'>\n      <li class=\'two-lines\'>\n        <div class=\'status status-added icon icon-diff-added\'></div>\n        <div class=\'primary-line icon icon-file-text\'>Primary line</div>\n        <div class=\'secondary-line no-icon\'>Secondary line</div>\n      </li>\n\n      <li class=\'two-lines selected\'>\n        <div class=\'status status-modified icon icon-diff-modified\'></div>\n        <div class=\'primary-line icon icon-file-symlink-file\'>A thing</div>\n        <div class=\'secondary-line no-icon\'>Description of the thing</div>\n      </li>\n\n      <li class=\'two-lines\'>\n        <div class=\'status status-renamed icon icon-diff-renamed\'></div>\n        <div class=\'primary-line icon icon-file-symlink-file\'>A thing</div>\n        <div class=\'secondary-line no-icon\'>Description of the thing</div>\n      </li>\n    </ol>\n  </div>\n</atom-panel>');
            this.h2('Using mark-active class to indicate the active item');
            this.p((function(_this) {
              return function() {
                return _this.raw('Use ...');
              };
            })(this));
            this.exampleHtml('<atom-panel class=\'modal\'>\n  <div class=\'select-list\'>\n    <ol class=\'list-group mark-active\'>\n      <li class=\'selected\'>Selected &mdash; user is arrowing through the list.</li>\n      <li class=\'active\'>This is the active item</li>\n      <li class=\'selected active\'>Selected AND Active!</li>\n    </ol>\n  </div>\n</atom-panel>');
            this.h2('Error messages');
            this.exampleHtml('<atom-panel class=\'modal\'>\n  <div class=\'select-list\'>\n    <atom-text-editor mini>I searched for this</atom-text-editor>\n    <div class=\'error-message\'>Nothing has been found!</div>\n  </div>\n</atom-panel>');
            this.h2('Loading message');
            return this.exampleHtml('<atom-panel class=\'modal\'>\n  <div class=\'select-list\'>\n    <atom-text-editor mini>User input</atom-text-editor>\n    <div class=\'loading\'>\n      <span class=\'loading-message\'>Chill, bro. Things are loading.</span>\n      <span class=\'badge\'>1234</span>\n    </div>\n  </div>\n</atom-panel>');
          });
          _this.exampleSection('popover-list', 'Popover List', function() {
            this.p((function(_this) {
              return function() {
                return _this.raw('A <code>.popover-list</code> is a <code>.select-list</code> that\nis meant to popover the code for something like autocomplete.');
              };
            })(this));
            this.h2('Basic example with one item selected');
            return this.exampleHtml('<div class=\'select-list popover-list\'>\n  <atom-text-editor mini>\'User types here..\'</atom-text-editor>\n  <ol class=\'list-group\'>\n    <li class=\'selected\'>one</li>\n    <li>two</li>\n    <li>three</li>\n  </ol>\n</div>');
          });
          _this.exampleSection('tooltips', 'Tooltips', function() {
            this.p((function(_this) {
              return function() {
                return _this.raw('You do not create the markup directly. You call\n<code>element.setTooltip(title, {command, commandElement}={})</code>.\nPassing in a <code>command</code> (like <code>find-and-replace:show-find</code>) and\n<code>commandElement</code> (context for the command) will yield a tip with a keystroke.');
              };
            })(this));
            return this.exampleHtml('<div class=\'tooltip top\'>\n  <div class=\'tooltip-arrow\'></div>\n  <div class=\'tooltip-inner\'>This is a message</div>\n</div>\n\n<div class=\'tooltip top\'>\n  <div class=\'tooltip-arrow\'></div>\n  <div class=\'tooltip-inner\'>\n    With a keystroke <span class="keystroke">cmd-shift-o</span>\n  </div>\n</div>');
          });
          _this.exampleSection('error-messages', 'Messages', function() {
            this.p((function(_this) {
              return function() {
                return _this.raw('Use to convey info to the user when something happens. See <code>find-and-replace</code>\nfor an example.');
              };
            })(this));
            this.h2('Error messages');
            this.exampleHtml('<ul class=\'error-messages block\'>\n  <li>This is an error!</li>\n  <li>And another</li>\n</ul>');
            this.h2('Info messages');
            return this.exampleHtml('<ul class=\'info-messages block\'>\n  <li>Info line</li>\n  <li>Another info line</li>\n</ul>');
          });
          _this.exampleSection('background-messages', 'Background Messages', function() {
            this.p((function(_this) {
              return function() {
                return _this.raw('Subtle background messages for panes. Use for cases when there are no results.');
              };
            })(this));
            this.exampleHtml('<ul class=\'background-message\'>\n  <li>No Results</li>\n</ul>');
            this.p((function(_this) {
              return function() {
                return _this.raw('Centered background messages will center horizontally and vertically.\nYour container for this element must have <code>position</code> set with <code>relative</code> or\n<code>absolute</code>.');
              };
            })(this));
            return this.exampleHtml('<ul class=\'background-message centered\'>\n  <li>No Results</li>\n</ul>');
          });
          _this.exampleSection('error-messages', 'Messages', function() {
            this.p((function(_this) {
              return function() {
                return _this.raw('Use to convey info to the user when something happens. See <code>find-and-replace</code>\nfor an example.');
              };
            })(this));
            this.h2('Error messages');
            return this.exampleHtml('<ul class=\'error-messages block\'>\n  <li>This is an error!</li>\n  <li>And another</li>\n</ul>');
          });
          return _this.exampleSection('progress', 'Loading/Progress', function() {
            this.h2('Progress Bars');
            this.exampleHtml('<div class=\'block\'>\n  <progress class=\'inline-block\'/>\n  <span class=\'inline-block\'>Indeterminate</span>\n</div>\n\n<div class=\'block\'>\n  <progress class=\'inline-block\', max=\'100\' value=\'25\'/>\n  <span class=\'inline-block\'>At 25%</span>\n</div>\n\n<div class=\'block\'>\n  <progress class=\'inline-block\', max=\'100\' value=\'50\'/>\n  <span class=\'inline-block\'>At 50%</span>\n</div>\n\n<div class=\'block\'>\n  <progress class=\'inline-block\' max=\'100\' value=\'75\'/>\n  <span class=\'inline-block\'>At 75%</span>\n</div>\n\n<div class=\'block\'>\n  <progress class=\'inline-block\', max=\'100\' value=\'100\'/>\n  <span class=\'inline-block\'>At 100%</span>\n</div>');
            this.h2('Loading Spinners');
            return this.exampleHtml('<span class=\'loading loading-spinner-tiny inline-block\'></span>\n<span class=\'loading loading-spinner-small inline-block\'></span>\n<span class=\'loading loading-spinner-medium inline-block\'></span>\n<span class=\'loading loading-spinner-large inline-block\'></span>');
          });
        };
      })(this));
    };

    StyleguideView.deserialize = function(options) {
      if (options == null) {
        options = {};
      }
      return new StyleguideView(options);
    };

    StyleguideView.exampleSections = {};

    StyleguideView.exampleSection = function(name, title, buildFn) {
      return this.exampleSections[name] = ExampleSection.build(this, name, title, buildFn);
    };

    StyleguideView.prototype.initialize = function(_arg) {
      var collapsedSections, section, __, _ref1, _ref2;
      _ref1 = _arg != null ? _arg : {}, this.uri = _ref1.uri, collapsedSections = _ref1.collapsedSections;
      this.on('click', '.section-heading', function() {
        return StyleguideView.exampleSections[$(this).parent().attr('data-name')].toggle();
      });
      this.on('click', '.example-code .btn-group .btn', function() {
        var btn, clas, example;
        btn = $(this);
        example = btn.parents('.example-code');
        clas = btn.attr('data-display-class');
        example.find('.btn').removeClass('selected');
        example.removeClass('show-example-html show-example-space-pen');
        example.addClass(clas);
        return btn.addClass('selected');
      });
      this.collapseAllButton.click(this.collapseAllSections);
      _ref2 = StyleguideView.exampleSections;
      for (__ in _ref2) {
        section = _ref2[__];
        this.append(section.el);
      }
      return this.setCollapsedSections(collapsedSections);
    };

    StyleguideView.prototype.serialize = function() {
      return {
        deserializer: this.constructor.name,
        collapsedSections: this.getCollapsedSections(),
        uri: this.getURI()
      };
    };

    StyleguideView.prototype.getURI = function() {
      return this.uri;
    };

    StyleguideView.prototype.getTitle = function() {
      return "Styleguide";
    };

    StyleguideView.prototype.onDidChangeTitle = function() {
      return new Disposable(function() {});
    };

    StyleguideView.prototype.onDidChangeModified = function() {
      return new Disposable(function() {});
    };

    StyleguideView.prototype.collapseAllSections = function() {
      var name, section, _ref1, _results;
      _ref1 = StyleguideView.exampleSections;
      _results = [];
      for (name in _ref1) {
        section = _ref1[name];
        if (name === 'styleguide') {
          continue;
        }
        _results.push(section.collapse());
      }
      return _results;
    };

    StyleguideView.prototype.getCollapsedSections = function() {
      var sec, _i, _len, _ref1, _results;
      _ref1 = this.find('section.collapsed');
      _results = [];
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        sec = _ref1[_i];
        _results.push($(sec).attr('data-name'));
      }
      return _results;
    };

    StyleguideView.prototype.setCollapsedSections = function(collapsedSections) {
      var name, section, _ref1;
      if (collapsedSections == null) {
        collapsedSections = [];
      }
      _ref1 = StyleguideView.exampleSections;
      for (name in _ref1) {
        section = _ref1[name];
        if (__indexOf.call(collapsedSections, name) < 0) {
          section.expand();
        }
      }
      return null;
    };

    StyleguideView.prototype.isEqual = function(other) {
      return other instanceof StyleguideView;
    };

    return StyleguideView;

  })(ScrollView);

}).call(this);
