(function() {
  var CompositeDisposable, StyleguideUri, createStyleguideView;

  CompositeDisposable = require('atom').CompositeDisposable;

  StyleguideUri = 'atom://styleguide';

  createStyleguideView = function(state) {
    var StyleguideView;
    StyleguideView = require('./styleguide-view');
    return new StyleguideView(state);
  };

  atom.deserializers.add({
    name: 'StyleguideView',
    deserialize: function(state) {
      return createStyleguideView(state);
    }
  });

  module.exports = {
    activate: function() {
      this.subscriptions = new CompositeDisposable;
      this.subscriptions.add(atom.workspace.addOpener(function(filePath) {
        if (filePath === StyleguideUri) {
          return createStyleguideView({
            uri: StyleguideUri
          });
        }
      }));
      return this.subscriptions.add(atom.commands.add('atom-workspace', 'styleguide:show', function() {
        return atom.workspace.open(StyleguideUri);
      }));
    },
    deactivate: function() {
      return this.subscriptions.dispose();
    }
  };

}).call(this);
