(function() {
  var classRegexpCache, psuedoClassRegexpCache;

  classRegexpCache = {};

  psuedoClassRegexpCache = {};

  module.exports = {
    eachSelector: function(css, fn) {
      var i, selector, selectors, _i, _len, _ref, _results;
      _ref = css.split(/{|}/);
      _results = [];
      for (i = _i = 0, _len = _ref.length; _i < _len; i = ++_i) {
        selectors = _ref[i];
        if (i % 2 === 0) {
          _results.push((function() {
            var _j, _len1, _ref1, _results1;
            _ref1 = selectors.split(",");
            _results1 = [];
            for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
              selector = _ref1[_j];
              selector = selector.trim();
              if (selector) {
                _results1.push(fn(selector));
              } else {
                _results1.push(void 0);
              }
            }
            return _results1;
          })());
        }
      }
      return _results;
    },
    selectorHasClass: function(selector, klass) {
      if (classRegexpCache[klass] == null) {
        classRegexpCache[klass] = new RegExp("\\." + klass + "([ >\.:]|$)");
      }
      return classRegexpCache[klass].test(selector);
    },
    selectorHasPsuedoClass: function(selector, klass) {
      if (psuedoClassRegexpCache[klass] == null) {
        psuedoClassRegexpCache[klass] = new RegExp("\\:" + klass + "([ >\.:]|$)");
      }
      return psuedoClassRegexpCache[klass].test(selector);
    }
  };

}).call(this);
