(function() {
  var $, SelectorLinter, eachSelector;

  $ = require('atom-space-pen-views').$;

  SelectorLinter = require('atom-selector-linter');

  describe("Style Guide", function() {
    var workspaceElement;
    workspaceElement = null;
    beforeEach(function() {
      workspaceElement = atom.views.getView(atom.workspace);
      return waitsForPromise(function() {
        return atom.packages.activatePackage("styleguide");
      });
    });
    return describe("the styleguide:show command", function() {
      var styleGuideView;
      styleGuideView = null;
      beforeEach(function() {
        atom.commands.dispatch(workspaceElement, "styleguide:show");
        styleGuideView = null;
        return waitsFor(function() {
          return styleGuideView = atom.workspace.getActivePaneItem();
        });
      });
      it("opens the style guide", function() {
        return expect(styleGuideView.text()).toContain("Styleguide");
      });
      return it("doesn't use deprecated selectors", function() {
        var examples, linter;
        linter = new SelectorLinter;
        examples = styleGuideView.find(".example-rendered");
        expect(examples.length).toBeGreaterThan(10);
        examples.each(function(_, example) {
          return eachSelector(example, function(element, selector) {
            if (!element.webkitMatchesSelector("atom-text-editor[mini]")) {
              return linter.check(selector, {
                packageName: "styleguide",
                sourcePath: "view"
              });
            }
          });
        });
        return expect(linter.getDeprecations()).toEqual({});
      });
    });
  });

  eachSelector = function(element, callback, prefix) {
    var child, klass, selector, _i, _j, _len, _len1, _ref, _ref1, _results;
    if (prefix == null) {
      prefix = "";
    }
    selector = prefix + " " + element.nodeName.toLowerCase();
    _ref = element.className.split(" ");
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      klass = _ref[_i];
      selector += "." + klass;
    }
    callback(element, selector);
    _ref1 = element.children;
    _results = [];
    for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
      child = _ref1[_j];
      _results.push(eachSelector(child, callback, selector));
    }
    return _results;
  };

}).call(this);
