(function() {
  var $$, CompositeDisposable, FileView, SymbolsView, TagGenerator,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  $$ = require('atom-space-pen-views').$$;

  CompositeDisposable = require('atom').CompositeDisposable;

  SymbolsView = require('./symbols-view');

  TagGenerator = require('./tag-generator');

  module.exports = FileView = (function(_super) {
    __extends(FileView, _super);

    function FileView() {
      return FileView.__super__.constructor.apply(this, arguments);
    }

    FileView.prototype.initialize = function() {
      FileView.__super__.initialize.apply(this, arguments);
      this.cachedTags = {};
      return this.editorsSubscription = atom.workspace.observeTextEditors((function(_this) {
        return function(editor) {
          var editorSubscriptions, removeFromCache;
          removeFromCache = function() {
            return delete _this.cachedTags[editor.getPath()];
          };
          editorSubscriptions = new CompositeDisposable();
          editorSubscriptions.add(editor.onDidChangeGrammar(removeFromCache));
          editorSubscriptions.add(editor.onDidSave(removeFromCache));
          editorSubscriptions.add(editor.onDidChangePath(removeFromCache));
          editorSubscriptions.add(editor.getBuffer().onDidReload(removeFromCache));
          editorSubscriptions.add(editor.getBuffer().onDidDestroy(removeFromCache));
          return editor.onDidDestroy(function() {
            return editorSubscriptions.dispose();
          });
        };
      })(this));
    };

    FileView.prototype.destroy = function() {
      this.editorsSubscription.dispose();
      return FileView.__super__.destroy.apply(this, arguments);
    };

    FileView.prototype.viewForItem = function(_arg) {
      var name, position;
      position = _arg.position, name = _arg.name;
      return $$(function() {
        return this.li({
          "class": 'two-lines'
        }, (function(_this) {
          return function() {
            _this.div(name, {
              "class": 'primary-line'
            });
            return _this.div("Line " + (position.row + 1), {
              "class": 'secondary-line'
            });
          };
        })(this));
      });
    };

    FileView.prototype.toggle = function() {
      var filePath;
      if (this.panel.isVisible()) {
        return this.cancel();
      } else if (filePath = this.getPath()) {
        this.populate(filePath);
        return this.attach();
      }
    };

    FileView.prototype.getPath = function() {
      var _ref;
      return (_ref = atom.workspace.getActiveTextEditor()) != null ? _ref.getPath() : void 0;
    };

    FileView.prototype.getScopeName = function() {
      var _ref, _ref1;
      return (_ref = atom.workspace.getActiveTextEditor()) != null ? (_ref1 = _ref.getGrammar()) != null ? _ref1.scopeName : void 0 : void 0;
    };

    FileView.prototype.populate = function(filePath) {
      var tags;
      this.list.empty();
      this.setLoading('Generating symbols\u2026');
      if (tags = this.cachedTags[filePath]) {
        this.setMaxItems(Infinity);
        return this.setItems(tags);
      } else {
        return this.generateTags(filePath);
      }
    };

    FileView.prototype.generateTags = function(filePath) {
      return new TagGenerator(filePath, this.getScopeName()).generate().done((function(_this) {
        return function(tags) {
          _this.cachedTags[filePath] = tags;
          _this.setMaxItems(Infinity);
          return _this.setItems(tags);
        };
      })(this));
    };

    return FileView;

  })(SymbolsView);

}).call(this);
