(function() {
  var GoToView, Q, SymbolsView, TagReader, path,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  path = require('path');

  Q = require('q');

  SymbolsView = require('./symbols-view');

  TagReader = require('./tag-reader');

  module.exports = GoToView = (function(_super) {
    __extends(GoToView, _super);

    function GoToView() {
      return GoToView.__super__.constructor.apply(this, arguments);
    }

    GoToView.prototype.toggle = function() {
      if (this.panel.isVisible()) {
        return this.cancel();
      } else {
        return this.populate();
      }
    };

    GoToView.prototype.detached = function() {
      var _ref;
      return (_ref = this.deferredFind) != null ? _ref.resolve([]) : void 0;
    };

    GoToView.prototype.findTag = function(editor) {
      var deferred, _ref;
      if ((_ref = this.deferredFind) != null) {
        _ref.resolve([]);
      }
      deferred = Q.defer();
      TagReader.find(editor, function(error, matches) {
        if (matches == null) {
          matches = [];
        }
        return deferred.resolve(matches);
      });
      this.deferredFind = deferred;
      return this.deferredFind.promise;
    };

    GoToView.prototype.populate = function() {
      var editor;
      editor = atom.workspace.getActiveTextEditor();
      if (editor == null) {
        return;
      }
      return this.findTag(editor).then((function(_this) {
        return function(matches) {
          var match, position, tags, _i, _len;
          tags = [];
          for (_i = 0, _len = matches.length; _i < _len; _i++) {
            match = matches[_i];
            position = _this.getTagLine(match);
            if (!position) {
              continue;
            }
            match.name = path.basename(match.file);
            tags.push(match);
          }
          if (tags.length === 1) {
            return _this.openTag(tags[0]);
          } else if (tags.length > 0) {
            _this.setItems(tags);
            return _this.attach();
          }
        };
      })(this));
    };

    return GoToView;

  })(SymbolsView);

}).call(this);
