(function() {
  var async, ctags, getTagsFile;

  async = require('async');

  ctags = require('ctags');

  getTagsFile = require('./get-tags-file');

  module.exports = function(directoryPaths) {
    return async.each(directoryPaths, function(directoryPath, done) {
      var stream, tagsFilePath;
      tagsFilePath = getTagsFile(directoryPath);
      if (!tagsFilePath) {
        return done();
      }
      stream = ctags.createReadStream(tagsFilePath);
      stream.on('data', function(tags) {
        var tag, _i, _len;
        for (_i = 0, _len = tags.length; _i < _len; _i++) {
          tag = tags[_i];
          tag.directory = directoryPath;
        }
        return emit('tags', tags);
      });
      stream.on('end', done);
      return stream.on('error', done);
    }, this.async());
  };

}).call(this);
