(function() {
  module.exports = {
    config: {
      useEditorGrammarAsCtagsLanguage: {
        "default": true,
        type: 'boolean'
      }
    },
    activate: function() {
      this.stack = [];
      this.workspaceSubscription = atom.commands.add('atom-workspace', {
        'symbols-view:toggle-project-symbols': (function(_this) {
          return function() {
            return _this.createProjectView().toggle();
          };
        })(this)
      });
      return this.editorSubscription = atom.commands.add('atom-text-editor', {
        'symbols-view:toggle-file-symbols': (function(_this) {
          return function() {
            return _this.createFileView().toggle();
          };
        })(this),
        'symbols-view:go-to-declaration': (function(_this) {
          return function() {
            return _this.createGoToView().toggle();
          };
        })(this),
        'symbols-view:return-from-declaration': (function(_this) {
          return function() {
            return _this.createGoBackView().toggle();
          };
        })(this)
      });
    },
    deactivate: function() {
      if (this.fileView != null) {
        this.fileView.destroy();
        this.fileView = null;
      }
      if (this.projectView != null) {
        this.projectView.destroy();
        this.projectView = null;
      }
      if (this.goToView != null) {
        this.goToView.destroy();
        this.goToView = null;
      }
      if (this.goBackView != null) {
        this.goBackView.destroy();
        this.goBackView = null;
      }
      if (this.workspaceSubscription != null) {
        this.workspaceSubscription.dispose();
        this.workspaceSubscription = null;
      }
      if (this.editorSubscription != null) {
        this.editorSubscription.dispose();
        return this.editorSubscription = null;
      }
    },
    createFileView: function() {
      var FileView;
      if (this.fileView == null) {
        FileView = require('./file-view');
        this.fileView = new FileView(this.stack);
      }
      return this.fileView;
    },
    createProjectView: function() {
      var ProjectView;
      if (this.projectView == null) {
        ProjectView = require('./project-view');
        this.projectView = new ProjectView(this.stack);
      }
      return this.projectView;
    },
    createGoToView: function() {
      var GoToView;
      if (this.goToView == null) {
        GoToView = require('./go-to-view');
        this.goToView = new GoToView(this.stack);
      }
      return this.goToView;
    },
    createGoBackView: function() {
      var GoBackView;
      if (this.goBackView == null) {
        GoBackView = require('./go-back-view');
        this.goBackView = new GoBackView(this.stack);
      }
      return this.goBackView;
    }
  };

}).call(this);
