(function() {
  var CompositeDisposable, File, ProjectView, SymbolsView, TagReader, getTagsFile, humanize,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  CompositeDisposable = require('atom').CompositeDisposable;

  File = require('pathwatcher').File;

  humanize = require('humanize-plus');

  SymbolsView = require('./symbols-view');

  TagReader = require('./tag-reader');

  getTagsFile = require('./get-tags-file');

  module.exports = ProjectView = (function(_super) {
    __extends(ProjectView, _super);

    function ProjectView() {
      return ProjectView.__super__.constructor.apply(this, arguments);
    }

    ProjectView.prototype.initialize = function() {
      ProjectView.__super__.initialize.apply(this, arguments);
      this.reloadTags = true;
      return this.setMaxItems(10);
    };

    ProjectView.prototype.destroy = function() {
      this.stopTask();
      this.unwatchTagsFiles();
      return ProjectView.__super__.destroy.apply(this, arguments);
    };

    ProjectView.prototype.toggle = function() {
      if (this.panel.isVisible()) {
        return this.cancel();
      } else {
        this.populate();
        return this.attach();
      }
    };

    ProjectView.prototype.getEmptyMessage = function(itemCount) {
      if (itemCount === 0) {
        return 'Project has no tags file or it is empty';
      } else {
        return ProjectView.__super__.getEmptyMessage.apply(this, arguments);
      }
    };

    ProjectView.prototype.populate = function() {
      var tagsRead;
      if (this.tags) {
        this.setItems(this.tags);
      }
      if (this.reloadTags) {
        this.reloadTags = false;
        this.startTask();
        if (this.tags) {
          return this.setLoading("Reloading project symbols\u2026");
        } else {
          this.setLoading('Loading project symbols\u2026');
          this.loadingBadge.text('0');
          tagsRead = 0;
          return this.loadTagsTask.on('tags', (function(_this) {
            return function(tags) {
              tagsRead += tags.length;
              return _this.loadingBadge.text(humanize.intComma(tagsRead));
            };
          })(this));
        }
      }
    };

    ProjectView.prototype.stopTask = function() {
      var _ref;
      return (_ref = this.loadTagsTask) != null ? _ref.terminate() : void 0;
    };

    ProjectView.prototype.startTask = function() {
      this.stopTask();
      this.loadTagsTask = TagReader.getAllTags((function(_this) {
        return function(tags) {
          _this.tags = tags;
          _this.reloadTags = _this.tags.length === 0;
          return _this.setItems(_this.tags);
        };
      })(this));
      return this.watchTagsFiles();
    };

    ProjectView.prototype.watchTagsFiles = function() {
      var projectPath, reloadTags, tagsFile, tagsFilePath, _i, _len, _ref;
      this.unwatchTagsFiles();
      this.tagsFileSubscriptions = new CompositeDisposable();
      reloadTags = (function(_this) {
        return function() {
          _this.reloadTags = true;
          return _this.watchTagsFiles();
        };
      })(this);
      _ref = atom.project.getPaths();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        projectPath = _ref[_i];
        if (tagsFilePath = getTagsFile(projectPath)) {
          tagsFile = new File(tagsFilePath);
          this.tagsFileSubscriptions.add(tagsFile.onDidChange(reloadTags));
          this.tagsFileSubscriptions.add(tagsFile.onDidDelete(reloadTags));
          this.tagsFileSubscriptions.add(tagsFile.onDidRename(reloadTags));
        }
      }
    };

    ProjectView.prototype.unwatchTagsFiles = function() {
      var _ref;
      if ((_ref = this.tagsFileSubscriptions) != null) {
        _ref.dispose();
      }
      return this.tagsFileSubscriptions = null;
    };

    return ProjectView;

  })(SymbolsView);

}).call(this);
